/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.png;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.decoder.png.IDATEnumeration;
import com.sun.jimi.core.util.JimiUtil;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class PNGReader {
    private int dataWidth;
    private int dataHeight;
    private int width = -1;
    private int height = -1;
    private int sigmask = 65535;
    private ColorModel model;
    private Object pixels;
    private int[] ipixels;
    private byte[] bpixels;
    private Hashtable properties;
    private Vector theConsumers;
    private boolean multipass;
    private boolean complete;
    private boolean error;
    InputStream underlyingStream_;
    DataInputStream inputStream;
    private Thread controlThread;
    private boolean infoAvailable = false;
    private boolean completePasses = false;
    private int updateDelay = 750;
    private boolean headerFound = false;
    private int compressionMethod = -1;
    private int depth = -1;
    private int colorType = -1;
    private int filterMethod = -1;
    private int interlaceMethod = -1;
    private int pass;
    private byte[] palette;
    private boolean transparency;
    int chunkLength;
    int chunkType;
    boolean needChunkInfo = true;
    static final int CHUNK_bKGD = 1649100612;
    static final int CHUNK_cHRM = 1665684045;
    static final int CHUNK_gAMA = 1732332865;
    static final int CHUNK_hIST = 1749635924;
    static final int CHUNK_IDAT = 1229209940;
    static final int CHUNK_IEND = 1229278788;
    static final int CHUNK_IHDR = 1229472850;
    static final int CHUNK_PLTE = 1347179589;
    static final int CHUNK_pHYs = 1883789683;
    static final int CHUNK_sBIT = 1933723988;
    static final int CHUNK_tEXt = 1950701684;
    static final int CHUNK_tIME = 1950960965;
    static final int CHUNK_tRNS = 1951551059;
    static final int CHUNK_zTXt = 2052348020;
    static final int[] startingRow = new int[]{0, 0, 0, 4, 0, 2, 0, 1};
    static final int[] startingCol = new int[]{0, 0, 4, 0, 2, 0, 1, 0};
    static final int[] rowInc = new int[]{1, 8, 8, 8, 4, 4, 2, 2};
    static final int[] colInc = new int[]{1, 8, 8, 4, 4, 2, 2, 1};
    static final int[] blockHeight = new int[]{1, 8, 8, 4, 4, 2, 2, 1};
    static final int[] blockWidth = new int[]{1, 8, 4, 4, 2, 2, 1, 1};
    static final int CT_PALETTE = 1;
    static final int CT_COLOR = 2;
    static final int CT_ALPHA = 4;
    static final int IT_GRAYSCALE = 0;
    static final int IT_RGB = 2;
    static final int IT_PALETTE = 3;
    static final int IT_GRAYALPHA = 4;
    static final int IT_RGBA = 6;
    AdaptiveRasterImage ji_;

    PNGReader(DataInputStream in, AdaptiveRasterImage ji) {
        this.underlyingStream_ = in;
        this.inputStream = in;
        this.ji_ = ji;
    }

    void decodeImage() throws JimiException {
        try {
            this.handleSignature();
            while (!this.complete && !this.error) {
                this.handleChunk();
            }
        }
        catch (IOException e) {
            throw new JimiException("IO Error");
        }
    }

    private void handleSignature() throws JimiException, IOException {
        if (this.inputStream.read() != 137 || this.inputStream.read() != 80 || this.inputStream.read() != 78 || this.inputStream.read() != 71 || this.inputStream.read() != 13 || this.inputStream.read() != 10 || this.inputStream.read() != 26 || this.inputStream.read() != 10) {
            throw new JimiException("Not a PNG File");
        }
    }

    private void handleChunk() throws JimiException, IOException {
        if (this.needChunkInfo) {
            this.chunkLength = this.inputStream.readInt();
            this.chunkType = this.inputStream.readInt();
            this.needChunkInfo = false;
        }
        switch (this.chunkType) {
            case 1649100612: {
                this.handlebKGD();
                break;
            }
            case 1665684045: {
                this.handlecHRM();
                break;
            }
            case 1732332865: {
                this.handlegAMA();
                break;
            }
            case 1749635924: {
                this.handlehIST();
                break;
            }
            case 1229209940: {
                this.handleIDAT();
                break;
            }
            case 1229278788: {
                this.handleIEND();
                break;
            }
            case 1229472850: {
                this.handleIHDR();
                break;
            }
            case 1883789683: {
                this.handlepHYs();
                break;
            }
            case 1347179589: {
                this.handlePLTE();
                break;
            }
            case 1933723988: {
                this.handlesBIT();
                break;
            }
            case 1950701684: {
                this.handletEXt();
                break;
            }
            case 1950960965: {
                this.handletIME();
                break;
            }
            case 1951551059: {
                this.handletRNS();
                break;
            }
            case 2052348020: {
                this.handlezTXt();
                break;
            }
            default: {
                this.inputStream.skip(this.chunkLength);
            }
        }
        int crc = this.inputStream.readInt();
        this.needChunkInfo = true;
    }

    private void handleIHDR() throws JimiException, IOException {
        if (this.headerFound) {
            throw new JimiException("Extraneous IHDR chunk encountered.");
        }
        if (this.chunkLength != 13) {
            throw new JimiException("IHDR chunk length wrong: " + this.chunkLength);
        }
        this.dataWidth = this.inputStream.readInt();
        this.dataHeight = this.inputStream.readInt();
        this.depth = this.inputStream.read();
        this.colorType = this.inputStream.read();
        this.compressionMethod = this.inputStream.read();
        this.filterMethod = this.inputStream.read();
        this.interlaceMethod = this.inputStream.read();
        this.headerFound = true;
    }

    private void handlePLTE() throws IOException {
        if (this.colorType == 3) {
            this.palette = new byte[this.chunkLength];
            this.inputStream.readFully(this.palette);
        } else {
            this.inputStream.skip(this.chunkLength);
        }
    }

    private void handletRNS() throws JimiException, IOException {
        int chunkLen = this.chunkLength;
        switch (this.colorType) {
            case 3: {
                if (this.palette == null) {
                    throw new JimiException("tRNS chunk encountered before pLTE");
                }
                int len = this.palette.length;
                this.transparency = true;
                int transLength = len / 3;
                byte[] trans = new byte[transLength];
                this.inputStream.readFully(trans, 0, this.chunkLength);
                for (int i = this.chunkLength; i < transLength; ++i) {
                    trans[i] = -1;
                }
                byte[] newPalette = new byte[len + transLength];
                int i = newPalette.length;
                while (i > 0) {
                    newPalette[--i] = trans[--transLength];
                    newPalette[--i] = this.palette[--len];
                    newPalette[--i] = this.palette[--len];
                    newPalette[--i] = this.palette[--len];
                }
                this.palette = newPalette;
                break;
            }
            default: {
                this.inputStream.skip(this.chunkLength);
            }
        }
    }

    private void handlezTXt() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handlebKGD() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handlecHRM() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handlegAMA() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handlehIST() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handleIEND() throws IOException {
        this.complete = true;
    }

    private void handlepHYs() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handlesBIT() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handletEXt() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handletIME() throws IOException {
        this.inputStream.skip(this.chunkLength);
    }

    private void handleIDAT() throws JimiException, IOException {
        if (!this.infoAvailable) {
            if (this.height != -1 && this.width != -1) {
                throw new JimiException("IDAT before IHDR");
            }
            this.width = this.dataWidth;
            this.height = this.dataHeight;
            this.createColorModel();
            this.ji_.setSize(this.width, this.height);
            this.ji_.setColorModel(this.model);
            this.ji_.setPixels();
            if (this.interlaceMethod != 0) {
                this.multipass = true;
            }
            this.infoAvailable = true;
        }
        this.readImageData();
    }

    private void readImageData() throws JimiException, IOException {
        SequenceInputStream dataStream = new SequenceInputStream(new IDATEnumeration(this));
        DataInputStream dis = new DataInputStream(new InflaterInputStream(dataStream, new Inflater()));
        int bps = 0;
        switch (this.colorType) {
            case 0: 
            case 3: {
                bps = this.depth;
                break;
            }
            case 2: {
                bps = 3 * this.depth;
                break;
            }
            case 4: {
                bps = this.depth << 1;
                break;
            }
            case 6: {
                bps = this.depth << 2;
            }
        }
        int filterOffset = bps + 7 >> 3;
        int n = this.pass = this.multipass ? 1 : 0;
        while (this.pass < 8) {
            int pass = this.pass;
            int rInc = rowInc[pass];
            int cInc = colInc[pass];
            int sCol = startingCol[pass];
            int val = (this.dataWidth - sCol + cInc - 1) / cInc;
            int samples = val * filterOffset;
            int rowSize = val * bps + 7 >> 3;
            int sRow = startingRow[pass];
            if (this.dataHeight > sRow && rowSize != 0) {
                int sInc = rInc * this.dataWidth;
                byte[] inbuf = new byte[rowSize];
                int[] pix = new int[rowSize];
                int[] upix = null;
                int[] temp = new int[rowSize];
                int nextY = sRow;
                boolean rows = false;
                for (int y = sRow; y < this.dataHeight; y += rInc) {
                    int rowFilter = dis.read();
                    dis.readFully(inbuf);
                    if (!this.filterRow(inbuf, pix, upix, rowFilter, filterOffset)) {
                        throw new JimiException("Unknown filter type: " + rowFilter);
                    }
                    this.insertJimiPixels(pix, samples, sCol, y);
                    upix = pix;
                    pix = temp;
                    temp = upix;
                }
                if (!this.multipass) break;
            }
            ++this.pass;
        }
        while (dis.read() != -1) {
        }
    }

    private void insertJimiPixels(int[] pix, int samples, int col, int row) throws JimiException {
        if (startingCol[this.pass] == 0 && colInc[this.pass] == 1) {
            switch (this.colorType) {
                case 0: {
                    if (this.depth == 16) {
                        byte[] buf2 = new byte[this.width];
                        int l = pix.length;
                        int k = this.width;
                        while (--k >= 0) {
                            buf2[k] = (byte)pix[l -= 2];
                        }
                        this.ji_.setChannel(3, row, buf2);
                        break;
                    }
                    byte[] buf2 = new byte[pix.length];
                    int k = pix.length;
                    while (--k >= 0) {
                        buf2[k] = (byte)pix[k];
                    }
                    if (this.depth == 8) {
                        this.ji_.setChannel(3, row, buf2);
                        break;
                    }
                    byte[] buf = new byte[this.width];
                    JimiUtil.expandPixels(this.depth, buf2, buf, buf.length);
                    this.ji_.setChannel(3, row, buf);
                    break;
                }
                case 4: {
                    int[] buf2 = new int[this.width];
                    if (this.depth == 16) {
                        int l = pix.length;
                        int k = this.width;
                        while (--k >= 0) {
                            buf2[k] = pix[l -= 2] | pix[l -= 2] << 8;
                        }
                        this.ji_.setChannel(row, buf2);
                        break;
                    }
                    int l = pix.length;
                    int k = this.width;
                    while (--k >= 0) {
                        buf2[k] = pix[--l] | pix[--l] << 8;
                    }
                    this.ji_.setChannel(row, buf2);
                    break;
                }
                case 2: {
                    int[] buf = new int[this.width];
                    if (this.depth == 8) {
                        int j = pix.length;
                        int i = this.width;
                        while (--i >= 0) {
                            buf[i] = pix[--j] | pix[--j] << 8 | pix[--j] << 16;
                        }
                        this.ji_.setChannel(row, buf);
                        break;
                    }
                    int j = pix.length;
                    int i = this.width;
                    while (--i >= 0) {
                        buf[i] = pix[j -= 2] | pix[j -= 2] << 8 | pix[j -= 2] << 16;
                    }
                    this.ji_.setChannel(row, buf);
                    break;
                }
                case 3: {
                    byte[] buf2 = new byte[pix.length];
                    int k = pix.length;
                    while (--k >= 0) {
                        buf2[k] = (byte)pix[k];
                    }
                    if (this.depth == 8) {
                        this.ji_.setChannel(0, row, buf2);
                        break;
                    }
                    byte[] buf = new byte[this.width];
                    JimiUtil.expandPixels(this.depth, buf2, buf, buf.length);
                    this.ji_.setChannel(0, row, buf);
                    break;
                }
                case 6: {
                    if (this.depth == 8) {
                        int[] buf = new int[this.width];
                        int j = pix.length;
                        int i = this.width;
                        while (--i >= 0) {
                            buf[i] = pix[--j] << 24 | pix[--j] | pix[--j] << 8 | pix[--j] << 16;
                        }
                        this.ji_.setChannel(row, buf);
                        break;
                    }
                    int[] buf = new int[this.width];
                    int j = pix.length;
                    int i = this.width;
                    while (--i >= 0) {
                        buf[i] = pix[j -= 2] << 24 | pix[j -= 2] | pix[j -= 2] << 8 | pix[j -= 2] << 16;
                    }
                    this.ji_.setChannel(row, buf);
                    break;
                }
            }
        } else {
            this.insertPixels(pix, samples, col, row);
        }
    }

    private void insertPixels(int[] pix, int samples, int col, int row) throws JimiException {
        switch (this.colorType) {
            case 0: 
            case 4: {
                this.insertGreyPixels(pix, samples, col, row);
                break;
            }
            case 2: {
                int j = 0;
                int cInc = colInc[this.pass];
                if (this.depth == 8) {
                    j = 0;
                    while (j < samples) {
                        this.ji_.setChannel(col, row, pix[j++] << 16 | pix[j++] << 8 | pix[j++]);
                        col += cInc;
                    }
                } else {
                    j = 0;
                    while (j < samples) {
                        this.ji_.setChannel(col, row, pix[j] << 16 | pix[j += 2] << 8 | pix[j += 2]);
                        j += 2;
                        col += cInc;
                    }
                }
                break;
            }
            case 3: {
                this.insertPalettedPixels(pix, samples, col, row);
                break;
            }
            case 6: {
                int j = 0;
                int[] ipix = this.ipixels;
                int cInc = colInc[this.pass];
                if (this.depth == 8) {
                    j = 0;
                    while (j < samples) {
                        this.ji_.setChannel(col, row, pix[j++] << 16 | pix[j++] << 8 | pix[j++] | pix[j++] << 24);
                        col += cInc;
                    }
                } else {
                    j = 0;
                    while (j < samples) {
                        this.ji_.setChannel(col, row, pix[j] << 16 | pix[j += 2] << 8 | pix[j += 2] | pix[j += 2] << 24);
                        j += 2;
                        col += cInc;
                    }
                }
                break;
            }
        }
    }

    private void insertGreyPixels(int[] pix, int samples, int col, int row) throws JimiException {
        int p = pix[0];
        int cInc = colInc[this.pass];
        int rs = 0;
        block0 : switch (this.colorType) {
            case 0: {
                switch (this.depth) {
                    case 1: {
                        int j = 0;
                        while (j < samples) {
                            if (rs != 0) {
                                --rs;
                            } else {
                                rs = 7;
                                p = pix[j >> 3];
                            }
                            this.ji_.setChannel(col, row, p >> rs & 1);
                            ++j;
                            col += cInc;
                        }
                        break block0;
                    }
                    case 2: {
                        int j = 0;
                        while (j < samples) {
                            if (rs != 0) {
                                rs -= 2;
                            } else {
                                rs = 6;
                                p = pix[j >> 2];
                            }
                            this.ji_.setChannel(col, row, p >> rs & 3);
                            ++j;
                            col += cInc;
                        }
                        break block0;
                    }
                    case 4: {
                        int j = 0;
                        while (j < samples) {
                            if (rs != 0) {
                                rs = 0;
                            } else {
                                rs = 4;
                                p = pix[j >> 1];
                            }
                            this.ji_.setChannel(col, row, p >> rs & 0xF);
                            ++j;
                            col += cInc;
                        }
                        break block0;
                    }
                    case 8: {
                        int j = 0;
                        while (j < samples) {
                            this.ji_.setChannel(col, row, pix[j]);
                            ++j;
                            col += cInc;
                        }
                        break block0;
                    }
                    case 16: {
                        int j = 0;
                        while (j < samples) {
                            this.ji_.setChannel(col, row, pix[j]);
                            j += 2;
                            col += cInc;
                        }
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                if (this.depth == 8) {
                    int j = 0;
                    while (j < samples) {
                        this.ji_.setChannel(col, row, pix[j++] << 8 | pix[j++]);
                        col += cInc;
                    }
                } else {
                    int j = 0;
                    while (j < samples) {
                        this.ji_.setChannel(col, row, pix[j] << 8 | pix[j += 2]);
                        j += 2;
                        col += cInc;
                    }
                }
                break;
            }
        }
    }

    private void insertPalettedPixels(int[] pix, int samples, int col, int row) throws JimiException {
        int rs = 0;
        int p = pix[0];
        byte[] bpix = this.bpixels;
        int cInc = colInc[this.pass];
        switch (this.depth) {
            case 1: {
                int j = 0;
                while (j < samples) {
                    if (rs != 0) {
                        --rs;
                    } else {
                        rs = 7;
                        p = pix[j >> 3];
                    }
                    this.ji_.setChannel(col, row, p >> rs & 1);
                    ++j;
                    col += cInc;
                }
                break;
            }
            case 2: {
                int j = 0;
                while (j < samples) {
                    if (rs != 0) {
                        rs -= 2;
                    } else {
                        rs = 6;
                        p = pix[j >> 2];
                    }
                    this.ji_.setChannel(col, row, p >> rs & 3);
                    ++j;
                    col += cInc;
                }
                break;
            }
            case 4: {
                int j = 0;
                while (j < samples) {
                    if (rs != 0) {
                        rs = 0;
                    } else {
                        rs = 4;
                        p = pix[j >> 1];
                    }
                    this.ji_.setChannel(col, row, p >> rs & 0xF);
                    ++j;
                    col += cInc;
                }
                break;
            }
            case 8: {
                int j = 0;
                while (j < samples) {
                    this.ji_.setChannel(col, row, pix[j]);
                    ++j;
                    col += cInc;
                }
                break;
            }
        }
    }

    private boolean filterRow(byte[] inbuf, int[] pix, int[] upix, int rowFilter, int boff) {
        int rowWidth = pix.length;
        switch (rowFilter) {
            case 0: {
                for (int x = 0; x < rowWidth; ++x) {
                    pix[x] = 0xFF & inbuf[x];
                }
                break;
            }
            case 1: {
                int x;
                for (x = 0; x < boff; ++x) {
                    pix[x] = 0xFF & inbuf[x];
                }
                while (x < rowWidth) {
                    pix[x] = 0xFF & inbuf[x] + pix[x - boff];
                    ++x;
                }
                break;
            }
            case 2: {
                if (upix != null) {
                    for (int x = 0; x < rowWidth; ++x) {
                        pix[x] = 0xFF & upix[x] + inbuf[x];
                    }
                } else {
                    for (int x = 0; x < rowWidth; ++x) {
                        pix[x] = 0xFF & inbuf[x];
                    }
                }
                break;
            }
            case 3: {
                if (upix != null) {
                    int rval;
                    int x;
                    for (x = 0; x < boff; ++x) {
                        rval = upix[x];
                        pix[x] = 0xFF & (rval >> 1) + inbuf[x];
                    }
                    while (x < rowWidth) {
                        rval = upix[x] + pix[x - boff];
                        pix[x] = 0xFF & (rval >> 1) + inbuf[x];
                        ++x;
                    }
                } else {
                    int x;
                    for (x = 0; x < boff; ++x) {
                        pix[x] = 0xFF & inbuf[x];
                    }
                    while (x < rowWidth) {
                        int rval = pix[x - boff];
                        pix[x] = 0xFF & (rval >> 1) + inbuf[x];
                        ++x;
                    }
                }
                break;
            }
            case 4: {
                if (upix != null) {
                    int x;
                    for (x = 0; x < boff; ++x) {
                        pix[x] = 0xFF & upix[x] + inbuf[x];
                    }
                    while (x < rowWidth) {
                        int pc;
                        int a = pix[x - boff];
                        int b = upix[x];
                        int c = upix[x - boff];
                        int p = a + b - c;
                        int pa = p > a ? p - a : a - p;
                        int pb = p > b ? p - b : b - p;
                        int n = pc = p > c ? p - c : c - p;
                        int rval = pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
                        pix[x] = 0xFF & rval + inbuf[x];
                        ++x;
                    }
                } else {
                    int x;
                    for (x = 0; x < boff; ++x) {
                        pix[x] = 0xFF & inbuf[x];
                    }
                    while (x < rowWidth) {
                        int rval = pix[x - boff];
                        pix[x] = 0xFF & rval + inbuf[x];
                        ++x;
                    }
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void createColorModel() throws JimiException, IOException {
        int mask = 0;
        mask = this.depth == 16 ? 255 : (1 << this.depth) - 1;
        switch (this.colorType) {
            case 3: {
                if (this.palette == null) {
                    throw new JimiException("No palette located");
                }
                if (this.transparency) {
                    this.model = new IndexColorModel(8, this.palette.length / 4, this.palette, 0, true);
                    break;
                }
                this.model = new IndexColorModel(8, this.palette.length / 3, this.palette, 0, false);
                break;
            }
            case 0: {
                if (this.depth == 16) {
                    this.model = new DirectColorModel(8, mask, mask, mask);
                    break;
                }
                this.model = new DirectColorModel(this.depth, mask, mask, mask);
                break;
            }
            case 2: {
                this.model = new DirectColorModel(24, 0xFF0000, 65280, 255);
                break;
            }
            case 4: {
                int smask = mask << 8;
                this.model = new DirectColorModel(16, smask, smask, smask, mask);
                break;
            }
            case 6: {
                this.model = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
                break;
            }
            default: {
                throw new JimiException("Image has unknown color type " + this.colorType);
            }
        }
    }
}

