/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.psd;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.psd.PSDColorMode;
import com.sun.jimi.core.decoder.psd.PSDFileHeader;
import com.sun.jimi.core.decoder.psd.PSDImageResources;
import com.sun.jimi.core.decoder.psd.PSDLayersMasks;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.Packbits;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PSDDecoder
extends JimiDecoderBase {
    private AdaptiveRasterImage ji;
    private InputStream in;
    private DataInputStream dIn;
    private int state;
    PSDFileHeader psdFH;
    PSDColorMode psdCM;
    PSDLayersMasks psdLM;
    PSDImageResources psdIR;
    short compression;
    short maxSLLen_;
    short[] scanlineLengths_;

    public void initDecoder(InputStream in, AdaptiveRasterImage ji) throws JimiException {
        this.in = in;
        this.dIn = new DataInputStream(new BufferedInputStream(in));
        this.ji = ji;
        this.state = 0;
    }

    public boolean driveDecoder() throws JimiException {
        try {
            this.psdFH = new PSDFileHeader(this.dIn);
            this.psdCM = new PSDColorMode(this.dIn, this.psdFH);
            this.initJimiImage();
            this.state |= 2;
            this.psdIR = new PSDImageResources(this.dIn);
            this.psdLM = new PSDLayersMasks(this.dIn);
            this.decodeImage();
            this.ji.addFullCoverage();
            this.state |= 4;
        }
        catch (IOException e) {
            throw new JimiException(e.getMessage());
        }
        return false;
    }

    public void freeDecoder() throws JimiException {
        this.in = null;
        this.ji = null;
    }

    public int getState() {
        return this.state;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji;
    }

    private void initJimiImage() throws JimiException {
        if (this.psdFH.signature != 943870035 || this.psdFH.version != 1) {
            throw new JimiException("PSDDecoder invalid PSD file format");
        }
        if (this.psdFH.mode == 0 && this.psdFH.depth != 1 || this.psdFH.mode != 0 && this.psdFH.depth != 8) {
            throw new JimiException("Unsupported depth for mode file format. mode = " + this.psdFH.mode + " depth = " + this.psdFH.depth);
        }
        this.ji.setSize(this.psdFH.columns, this.psdFH.rows);
        switch (this.psdFH.mode) {
            case 3: {
                this.ji.setColorModel(new DirectColorModel(24, 0xFF0000, 65280, 255));
                this.ji.setPixels();
                this.ji.setChannel(-1048576L);
                break;
            }
            case 2: {
                if (this.psdFH.channels != 1) {
                    throw new JimiException("PSDDecoder INDEXED mode files must have 1 channel");
                }
                if (this.psdCM.length == 0) {
                    throw new JimiException("PSDDecoder INDEXED mode files require a color mode section");
                }
                this.ji.setColorModel(new IndexColorModel(8, this.psdCM.cmap.length / 3, this.psdCM.cmap, 0, false));
                this.ji.setPixels();
                break;
            }
            case 1: {
                if (this.psdFH.channels != 1) {
                    throw new JimiException("PSDDecoder GRAYSCALE mode files must have 1 channel");
                }
                this.ji.setColorModel(new DirectColorModel(8, 255, 255, 255));
                this.ji.setPixels();
                break;
            }
            case 0: {
                if (this.psdFH.channels != 1 || this.psdFH.depth != 1) {
                    throw new JimiException("PSDDecoder BITMAP must be 1 channel and 1 bit depth");
                }
                this.ji.setColorModel(new DirectColorModel(1, 1, 1, 1));
                this.ji.setPixels();
                break;
            }
            default: {
                throw new JimiException("PSDDecoder unsupported image mode format " + this.psdFH.mode);
            }
        }
    }

    void decodeImage() throws JimiException, IOException {
        this.compression = this.dIn.readShort();
        if (this.compression != 1 && this.compression != 0) {
            throw new JimiException("PSDDecoder invalid compression code " + this.compression);
        }
        switch (this.psdFH.mode) {
            case 3: {
                if (this.compression == 0) {
                    this.decodeRawRGB();
                    break;
                }
                this.decodeSLLData();
                this.decodeCompressedRGB();
                break;
            }
            case 2: {
                if (this.compression == 0) {
                    this.decodeRawChannel();
                    break;
                }
                this.decodeSLLData();
                this.decodeCompressedChannel();
                break;
            }
            case 1: {
                if (this.compression == 0) {
                    this.decodeRawChannel();
                    break;
                }
                this.decodeSLLData();
                this.decodeCompressedChannel();
                break;
            }
            case 0: {
                if (this.compression == 0) {
                    this.decodeRawBitmapChannel();
                    break;
                }
                this.decodeSLLData();
                this.decodeCompressedBitmapChannel();
            }
        }
    }

    private void decodeRawRGB() throws JimiException, IOException {
        int i;
        byte[] buf = new byte[this.psdFH.columns];
        int progressRoof = this.psdFH.rows * Math.min(4, this.psdFH.channels);
        int rows = this.psdFH.rows;
        for (i = 0; i < this.psdFH.rows; ++i) {
            this.dIn.readFully(buf);
            this.ji.setChannel(16, i, buf);
            this.setProgress(i * 100 / progressRoof);
        }
        for (i = 0; i < this.psdFH.rows; ++i) {
            this.dIn.readFully(buf);
            this.ji.setChannel(8, i, buf);
            this.setProgress((rows + i) * 100 / progressRoof);
        }
        for (i = 0; i < this.psdFH.rows; ++i) {
            this.dIn.readFully(buf);
            this.ji.setChannel(0, i, buf);
            this.setProgress((rows * 2 + i) * 100 / progressRoof);
        }
        if (this.psdFH.channels >= 4) {
            for (i = 0; i < this.psdFH.rows; ++i) {
                this.dIn.readFully(buf);
                this.ji.setChannel(24, i, buf);
                this.setProgress((rows * 3 + i) * 100 / progressRoof);
            }
        }
    }

    private void decodeCompressedRGB() throws JimiException, IOException {
        int i;
        byte[] ubuf = new byte[this.psdFH.columns];
        byte[] packed = new byte[this.maxSLLen_];
        int progressRoof = this.psdFH.rows * 3;
        int rows = this.psdFH.rows;
        for (i = 0; i < this.psdFH.rows; ++i) {
            this.dIn.readFully(packed, 0, this.scanlineLengths_[i]);
            Packbits.unpackbits(packed, ubuf);
            this.ji.setChannel(16, i, ubuf);
            this.setProgress(i * 100 / progressRoof);
        }
        for (i = 0; i < this.psdFH.rows; ++i) {
            this.dIn.readFully(packed, 0, this.scanlineLengths_[i + this.psdFH.rows]);
            Packbits.unpackbits(packed, ubuf);
            this.ji.setChannel(8, i, ubuf);
            this.setProgress((rows + i) * 100 / progressRoof);
        }
        for (i = 0; i < this.psdFH.rows; ++i) {
            this.dIn.readFully(packed, 0, this.scanlineLengths_[i + 2 * this.psdFH.rows]);
            Packbits.unpackbits(packed, ubuf);
            this.ji.setChannel(0, i, ubuf);
            this.setProgress((rows * 2 + i) * 100 / progressRoof);
        }
        if (this.psdFH.channels >= 4) {
            for (i = 0; i < this.psdFH.rows; ++i) {
                this.dIn.readFully(packed, 0, this.scanlineLengths_[i + 3 * this.psdFH.rows]);
                Packbits.unpackbits(packed, ubuf);
                this.ji.setChannel(24, i, ubuf);
                this.setProgress((rows * 3 + i) * 100 / progressRoof);
            }
        }
    }

    private void decodeRawChannel() throws JimiException, IOException {
        byte[] buf = new byte[this.psdFH.columns];
        for (int i = 0; i < this.psdFH.rows; ++i) {
            this.dIn.readFully(buf);
            this.ji.setChannel(0, i, buf);
            this.setProgress(i * 100 / this.psdFH.rows);
        }
    }

    private void decodeRawBitmapChannel() throws JimiException, IOException {
        byte[] preBuf = new byte[this.psdFH.columns / 8 + (this.psdFH.columns % 8 != 0 ? 1 : 0)];
        byte[] buf = new byte[this.psdFH.columns];
        for (int i = 0; i < this.psdFH.rows; ++i) {
            this.dIn.readFully(preBuf);
            int j = preBuf.length;
            while (--j >= 0) {
                preBuf[j] = ~preBuf[j];
            }
            JimiUtil.expandPixels(1, preBuf, buf, buf.length);
            this.ji.setChannel(0, i, buf);
            this.setProgress(i * 100 / this.psdFH.rows);
        }
    }

    private void decodeCompressedBitmapChannel() throws JimiException, IOException {
        byte[] rawBuf = new byte[this.maxSLLen_];
        byte[] preBuf = new byte[this.psdFH.columns / 8 + (this.psdFH.columns % 8 != 0 ? 1 : 0)];
        byte[] buf = new byte[this.psdFH.columns];
        for (int i = 0; i < this.psdFH.rows; ++i) {
            this.dIn.readFully(rawBuf, 0, this.scanlineLengths_[i]);
            Packbits.unpackbits(rawBuf, preBuf);
            int j = preBuf.length;
            while (--j >= 0) {
                preBuf[j] = ~preBuf[j];
            }
            JimiUtil.expandPixels(1, preBuf, buf, buf.length);
            this.ji.setChannel(0, i, buf);
            this.setProgress(i * 100 / this.psdFH.rows);
        }
    }

    private void decodeCompressedChannel() throws JimiException, IOException {
        byte[] ubuf = new byte[this.psdFH.columns];
        byte[] packed = new byte[this.maxSLLen_];
        for (int i = 0; i < this.psdFH.rows; ++i) {
            this.dIn.readFully(packed, 0, this.scanlineLengths_[i]);
            Packbits.unpackbits(packed, ubuf);
            this.ji.setChannel(0, i, ubuf);
            this.setProgress(i * 100 / this.psdFH.rows);
        }
    }

    private void decodeSLLData() throws IOException {
        this.scanlineLengths_ = new short[this.psdFH.rows * this.psdFH.channels];
        this.maxSLLen_ = (short)-1;
        for (int i = 0; i < this.psdFH.rows * this.psdFH.channels; ++i) {
            short slLen;
            this.scanlineLengths_[i] = slLen = this.dIn.readShort();
            this.maxSLLen_ = slLen > this.maxSLLen_ ? slLen : this.maxSLLen_;
        }
    }

    public boolean usesChanneledData() {
        return true;
    }
}

