/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.psd;

import com.sun.jimi.core.JimiException;
import java.io.DataInputStream;
import java.io.IOException;

public class PSDFileHeader {
    static final int PSD_SIGNATURE = 943870035;
    static final short BITMAP = 0;
    static final short GRAYSCALE = 1;
    static final short INDEXED = 2;
    static final short RGB = 3;
    static final short CMYK = 4;
    static final short MULTICHANNEL = 7;
    static final short DUOTONE = 8;
    static final short LAB = 9;
    int signature;
    short version;
    byte[] reserved;
    short channels;
    int rows;
    int columns;
    short depth;
    short mode;

    PSDFileHeader(DataInputStream in) throws JimiException, IOException {
        this.signature = in.readInt();
        if (this.signature != 943870035) {
            throw new JimiException("PSDFileHeader not a valid Photoshop file");
        }
        this.version = in.readShort();
        this.reserved = new byte[6];
        int ret = in.read(this.reserved, 0, 6);
        if (ret != 6) {
            throw new IOException();
        }
        this.channels = in.readShort();
        this.rows = in.readInt();
        this.columns = in.readInt();
        this.depth = in.readShort();
        this.mode = in.readShort();
    }

    public String toString() {
        return "s " + this.signature + " v " + this.version + " ch " + this.channels + " r " + this.rows + " co " + this.columns + " d " + this.depth + " c " + this.mode;
    }
}

