/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.sunraster;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RLEInputStream
extends FilterInputStream {
    protected static final int RLE_ESCAPE = 128;
    protected int runLength_;
    protected int runValue_;

    public RLEInputStream(InputStream source) {
        super(source);
    }

    public int read() throws IOException {
        if (this.runLength_ != 0) {
            --this.runLength_;
            return this.runValue_;
        }
        int value = super.read() & 0xFF;
        if (value == 128) {
            int count = super.read() & 0xFF;
            if (count == 0) {
                return 128;
            }
            this.runLength_ = count;
            this.runValue_ = super.read() & 0xFF;
            return this.runValue_;
        }
        return value;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int value;
        int count;
        for (count = 0; count < len && (value = this.read()) != -1; ++count) {
            buf[off + count] = (byte)value;
        }
        return count;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public void skip(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.read();
        }
    }

    public boolean markSupported() {
        return false;
    }
}

