/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.sunraster;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.sunraster.RLEInputStream;
import com.sun.jimi.core.decoder.sunraster.SunRasterColorMap;
import com.sun.jimi.core.decoder.sunraster.SunRasterHeader;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SunRasterDecoder
extends JimiDecoderBase {
    DataInputStream lin;
    AdaptiveRasterImage sinkImage;
    SunRasterHeader header;
    SunRasterColorMap colormap;
    int state;
    private static final int RLE_ESCAPE = 128;

    public void initDecoder(InputStream in, AdaptiveRasterImage ji) throws JimiException {
        if (in == null || ji == null) {
            throw new IllegalArgumentException("Null values to constructor.");
        }
        this.lin = new DataInputStream(in);
        this.sinkImage = ji;
        this.state = 0;
    }

    public void freeDecoder() throws JimiException {
        this.lin = null;
        this.sinkImage = null;
        this.header = null;
        this.colormap = null;
    }

    public boolean driveDecoder() throws JimiException {
        try {
            this.sinkImage = this.getJimiImage();
            if (this.state == 0) {
                this.header = new SunRasterHeader(this.lin);
                if (this.header.ColorMapType != 0) {
                    this.colormap = new SunRasterColorMap(this.lin, this.header);
                } else if (this.header.ColorMapType == 2) {
                    throw new JimiException("Unsupported Format Subtype");
                }
                this.initJimiImage();
                this.state |= 2;
                return true;
            }
            if (this.decodeImage()) {
                this.state |= 4;
            }
            this.sinkImage.addFullCoverage();
        }
        catch (JimiException je) {
            this.state |= 1;
            throw je;
        }
        catch (IOException ioe) {
            this.state |= 1;
            throw new JimiException("IOException while reading file : " + ioe.toString());
        }
        return false;
    }

    public int getState() {
        return this.state;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.sinkImage;
    }

    private void initJimiImage() throws JimiException {
        this.sinkImage.setSize(this.header.Width, this.header.Height);
        if (this.colormap == null) {
            int mask = 0;
            for (int i = this.header.Depth / 3; i > 0; --i) {
                mask <<= 1;
                ++mask;
            }
            this.sinkImage.setColorModel(new DirectColorModel(24, 0xFF0000, 65280, 255));
        } else if (this.colormap.RGBType) {
            this.sinkImage.setColorModel(new IndexColorModel(8, this.colormap.tableLength, this.colormap.r, this.colormap.g, this.colormap.b));
        } else {
            this.sinkImage.setColorModel(new IndexColorModel(8, this.colormap.tableLength, this.colormap.raw, 0, false));
        }
        this.sinkImage.setPixels();
    }

    private boolean decodeImage() throws IOException, JimiException {
        block24: {
            try {
                if (this.header.Type == 2) {
                    this.RLEDecodeImage();
                    break block24;
                }
                int scanlineSize = this.header.Width * this.header.Depth;
                if (scanlineSize % 16 != 0) {
                    scanlineSize += 16 - scanlineSize % 16;
                }
                scanlineSize /= 8;
                if (this.header.Depth == 8) {
                    byte[] data = new byte[this.header.Width];
                    for (int lineNum = 0; lineNum < this.header.Height; ++lineNum) {
                        this.lin.readFully(data, 0, this.header.Width);
                        this.lin.skipBytes(scanlineSize - data.length);
                        this.sinkImage.setChannel(0, lineNum, data);
                        this.setProgress(lineNum * 100 / this.header.Height);
                    }
                    break block24;
                }
                if (this.header.Depth == 4) {
                    byte[] data = new byte[this.header.Width];
                    for (int lineNum = 0; lineNum < this.header.Height; ++lineNum) {
                        for (int i = 0; i < data.length; i += 2) {
                            byte t1 = this.lin.readByte();
                            data[i] = (byte)(t1 >> 4);
                            data[i + 1] = (byte)(t1 & 0xF);
                        }
                        this.lin.skipBytes(scanlineSize - data.length / 2);
                        this.sinkImage.setChannel(0, lineNum, data);
                        this.setProgress(lineNum * 100 / this.header.Height);
                    }
                    break block24;
                }
                if (this.header.Depth < 8) break block24;
                if (this.header.Depth == 16) {
                    int[] data = new int[this.header.Width];
                    for (int lineNum = 0; lineNum < this.header.Height; ++lineNum) {
                        for (int i = 0; i < data.length; ++i) {
                            data[i] = this.lin.readInt();
                        }
                        this.lin.skipBytes(scanlineSize - data.length * 2);
                        this.sinkImage.setChannel(lineNum, data);
                        this.setProgress(lineNum * 100 / this.header.Height);
                    }
                    break block24;
                }
                if (this.header.Depth < 16) break block24;
                if (this.header.Depth == 24) {
                    int[] data = new int[this.header.Width];
                    for (int lineNum = 0; lineNum < this.header.Height; ++lineNum) {
                        int t3;
                        int t2;
                        int t1;
                        int i;
                        if (this.header.Type == 3) {
                            for (i = 0; i < data.length; ++i) {
                                t1 = this.lin.readUnsignedByte();
                                t2 = this.lin.readUnsignedByte();
                                t3 = this.lin.readUnsignedByte();
                                data[i] = t1 << 16 | t2 << 8 | t3;
                            }
                        } else {
                            for (i = 0; i < data.length; ++i) {
                                t1 = this.lin.readUnsignedByte();
                                t2 = this.lin.readUnsignedByte();
                                t3 = this.lin.readUnsignedByte();
                                data[i] = t3 << 16 | t2 << 8 | t1;
                            }
                        }
                        this.lin.skipBytes(scanlineSize - data.length * 3);
                        this.sinkImage.setChannel(lineNum, data);
                        this.setProgress(lineNum * 100 / this.header.Height);
                    }
                    break block24;
                }
                if (this.header.Depth != 32) break block24;
                int[] data = new int[this.header.Width];
                for (int lineNum = 0; lineNum < this.header.Height; ++lineNum) {
                    int t3;
                    int t2;
                    int t1;
                    int i;
                    if (this.header.Type == 3) {
                        for (i = 0; i < data.length; ++i) {
                            this.lin.readByte();
                            t1 = this.lin.readUnsignedByte();
                            t2 = this.lin.readUnsignedByte();
                            t3 = this.lin.readUnsignedByte();
                            data[i] = t1 << 16 | t2 << 8 | t3;
                        }
                    } else {
                        for (i = 0; i < data.length; ++i) {
                            this.lin.readByte();
                            t1 = this.lin.readUnsignedByte();
                            t2 = this.lin.readUnsignedByte();
                            t3 = this.lin.readUnsignedByte();
                            data[i] = t3 << 16 | t2 << 8 | t1;
                        }
                    }
                    this.lin.skipBytes(scanlineSize - data.length * 4);
                    this.sinkImage.setChannel(lineNum, data);
                    this.setProgress(lineNum * 100 / this.header.Height);
                }
            }
            catch (JimiException e) {
                throw e;
            }
            catch (IOException ioe) {
                throw ioe;
            }
        }
        this.state |= 4;
        return true;
    }

    protected void RLEDecodeImage() throws IOException, JimiException {
        RLEInputStream in = new RLEInputStream(this.lin);
        byte[] buf = new byte[this.header.Width];
        boolean pad = buf.length % 2 != 0;
        int height = this.header.Height;
        for (int line = 0; line < height; ++line) {
            ((InputStream)in).read(buf);
            if (pad) {
                ((InputStream)in).read();
            }
            SunRasterDecoder.flushOut(buf, this.sinkImage, line);
        }
    }

    private static void flushOut(byte[] data, AdaptiveRasterImage sink, int lineNum) throws JimiException {
        sink.setChannel(0, lineNum, data);
    }

    public boolean usesChanneledData() {
        return true;
    }
}

