/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tga;

import com.sun.jimi.core.decoder.tga.TGAFileHeader;
import com.sun.jimi.core.util.LEDataInputStream;
import java.io.IOException;

public class TGAColorMap {
    byte[] cmap;

    public TGAColorMap(LEDataInputStream in, TGAFileHeader tgaFH) throws IOException {
        if (tgaFH.colorMapType == 1) {
            switch (tgaFH.colorMapEntrySize) {
                case 8: {
                    this.cmap = new byte[tgaFH.colorMapLength];
                    int o = 0;
                    for (int i = tgaFH.firstEntryIndex; i < tgaFH.colorMapLength; ++i) {
                        byte b;
                        this.cmap[o] = b = in.readByte();
                        this.cmap[++o] = b;
                        this.cmap[++o] = b;
                        ++o;
                    }
                    break;
                }
                case 15: 
                case 16: {
                    this.cmap = new byte[tgaFH.colorMapLength * 3];
                    int o = tgaFH.firstEntryIndex * 3;
                    for (int i = tgaFH.firstEntryIndex; i < tgaFH.colorMapLength; ++i) {
                        short val = in.readShort();
                        this.cmap[o] = (byte)((val >> 10 & 0x1F) * 255 / 31);
                        this.cmap[++o] = (byte)((val >> 5 & 0x1F) * 255 / 31);
                        this.cmap[++o] = (byte)((val & 0x1F) * 255 / 31);
                        ++o;
                    }
                    break;
                }
                case 24: {
                    this.cmap = new byte[tgaFH.colorMapLength * 3];
                    int o = tgaFH.firstEntryIndex * 3;
                    for (int i = tgaFH.firstEntryIndex; i < tgaFH.colorMapLength; ++i) {
                        byte red;
                        byte blue = in.readByte();
                        byte green = in.readByte();
                        this.cmap[o] = red = in.readByte();
                        this.cmap[++o] = green;
                        this.cmap[++o] = blue;
                        ++o;
                    }
                    break;
                }
                case 32: {
                    this.cmap = new byte[tgaFH.colorMapLength * 4];
                    int o = tgaFH.firstEntryIndex * 4;
                    for (int i = tgaFH.firstEntryIndex; i < tgaFH.colorMapLength; ++i) {
                        byte blue = in.readByte();
                        byte green = in.readByte();
                        byte red = in.readByte();
                        byte alpha = in.readByte();
                        this.cmap[o] = red;
                        this.cmap[++o] = green;
                        this.cmap[++o] = blue;
                        this.cmap[++o] = alpha;
                        ++o;
                    }
                    break;
                }
            }
        }
    }
}

