/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tga;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.tga.TGAColorMap;
import com.sun.jimi.core.decoder.tga.TGAFileHeader;
import com.sun.jimi.core.util.LEDataInputStream;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TGADecoder
extends JimiDecoderBase {
    private AdaptiveRasterImage ji;
    private InputStream in;
    private LEDataInputStream dIn;
    private int state;
    TGAFileHeader tgaFH;
    TGAColorMap tgaCM;

    public void initDecoder(InputStream in, AdaptiveRasterImage ji) throws JimiException {
        this.in = in;
        this.dIn = new LEDataInputStream(new BufferedInputStream(in));
        this.ji = ji;
        this.state = 0;
    }

    public boolean driveDecoder() throws JimiException {
        try {
            this.tgaFH = new TGAFileHeader(this.dIn);
            this.tgaCM = new TGAColorMap(this.dIn, this.tgaFH);
            this.initJimiImage();
            this.state |= 2;
            this.decodeImage(this.dIn);
            this.state |= 4;
            this.ji.addFullCoverage();
        }
        catch (IOException e) {
            throw new JimiException("IO error reading TGA file");
        }
        return false;
    }

    public void freeDecoder() throws JimiException {
        this.in = null;
        this.dIn = null;
        this.ji = null;
    }

    public int getState() {
        return this.state;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji;
    }

    private void initJimiImage() throws JimiException {
        block0 : switch (this.tgaFH.imageType) {
            case 0: {
                throw new JimiException("TGADecoder no image found.");
            }
            case 1: 
            case 9: {
                if (this.tgaFH.colorMapType == 0) {
                    throw new JimiException("TGADecoder color mapped images require a color map.");
                }
                this.ji.setColorModel(new IndexColorModel(8, this.tgaCM.cmap.length / 3, this.tgaCM.cmap, 0, this.tgaFH.colorMapEntrySize == 32));
                break;
            }
            case 3: 
            case 11: {
                if (this.tgaFH.colorMapType != 0) {
                    throw new JimiException("TGADecoder gray scale should not have color map.");
                }
                this.ji.setColorModel(new DirectColorModel(8, 255, 255, 255));
                break;
            }
            case 2: 
            case 10: {
                switch (this.tgaFH.pixelDepth) {
                    case 16: {
                        this.ji.setColorModel(new DirectColorModel(16, 31744, 992, 31));
                        break block0;
                    }
                    case 24: 
                    case 32: {
                        this.ji.setColorModel(new DirectColorModel(24, 0xFF0000, 65280, 255));
                    }
                }
            }
        }
        this.ji.setSize(this.tgaFH.width, this.tgaFH.height);
        this.ji.setPixels();
    }

    private void decodeImage(LEDataInputStream dIn) throws JimiException, IOException {
        switch (this.tgaFH.imageType) {
            case 1: {
                this.decodeImageU8(dIn);
                break;
            }
            case 2: {
                switch (this.tgaFH.pixelDepth) {
                    case 16: {
                        this.decodeRGBImageU16(dIn);
                        break;
                    }
                    case 24: 
                    case 32: {
                        this.decodeRGBImageU24_32(dIn);
                    }
                }
                break;
            }
            case 3: {
                this.decodeImageU8(dIn);
                break;
            }
            case 9: {
                throw new JimiException("TGADecoder Compressed Colormapped images not supported");
            }
            case 10: {
                throw new IOException("TGADecoder Compressed True Color images not supported");
            }
            case 11: {
                throw new IOException("TGADecoder Compressed Grayscale images not supported");
            }
        }
    }

    private void decodeImageU8(LEDataInputStream dIn) throws IOException, JimiException {
        byte[] scanLine = new byte[this.tgaFH.width];
        for (int i = 0; i < this.tgaFH.height; ++i) {
            dIn.readFully(scanLine, 0, this.tgaFH.width);
            int y = this.tgaFH.topToBottom ? i : this.tgaFH.height - i - 1;
            this.ji.setChannel(0, y, scanLine);
            this.setProgress(i * 100 / this.tgaFH.height);
        }
    }

    private void decodeRGBImageU24_32(LEDataInputStream dIn) throws IOException, JimiException {
        int rawWidth = this.tgaFH.width * (this.tgaFH.pixelDepth / 8);
        byte[] rawBuf = new byte[rawWidth];
        int[] scanLine = new int[this.tgaFH.width];
        for (int i = 0; i < this.tgaFH.height; ++i) {
            int j;
            int raw;
            dIn.readFully(rawBuf, 0, rawWidth);
            if (this.tgaFH.pixelDepth == 24) {
                raw = 0;
                for (j = 0; j < this.tgaFH.width; ++j) {
                    scanLine[j] = -16777216 + ((rawBuf[raw + 2] & 0xFF) << 16) + ((rawBuf[raw + 1] & 0xFF) << 8) + (rawBuf[raw] & 0xFF);
                    raw += 3;
                }
            } else if (this.tgaFH.pixelDepth == 32) {
                raw = 0;
                for (j = 0; j < this.tgaFH.width; ++j) {
                    scanLine[j] = ((rawBuf[raw + 3] & 0xFF) << 24) + ((rawBuf[raw + 2] & 0xFF) << 16) + ((rawBuf[raw + 1] & 0xFF) << 8) + (rawBuf[raw] & 0xFF);
                    raw += 4;
                }
            } else {
                throw new JimiException("TGADecoder pixelDepth not 24 or 32");
            }
            int y = this.tgaFH.topToBottom ? i : this.tgaFH.height - i - 1;
            this.ji.setChannel(y, scanLine);
            this.setProgress(i * 100 / this.tgaFH.height);
        }
    }

    private void decodeRGBImageU16(LEDataInputStream dIn) throws IOException, JimiException {
        int[] scanLine = new int[this.tgaFH.width];
        for (int i = 0; i < this.tgaFH.height; ++i) {
            for (int j = 0; j < this.tgaFH.width; ++j) {
                scanLine[j] = dIn.readUnsignedShort() & Short.MAX_VALUE;
            }
            int y = this.tgaFH.topToBottom ? i : this.tgaFH.height - i - 1;
            this.ji.setChannel(y, scanLine);
            this.setProgress(i * 100 / this.tgaFH.height);
        }
    }
}

