/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tiff;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.decoder.tiff.CCITT3d1Decomp;
import com.sun.jimi.core.decoder.tiff.TiffNumberReader;

class CCITT3d2Decomp
extends CCITT3d1Decomp {
    private byte[] LastLine;
    static final byte[] zeroRuns = new byte[]{8, 7, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final byte[] oneRuns = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 7, 8};
    static final int[] bitMask_ = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    public static final int modePass = 1;
    public static final int modeHorizontal = 2;
    public static final int modeV0 = 3;
    public static final int modeVR1 = 4;
    public static final int modeVR2 = 5;
    public static final int modeVR3 = 6;
    public static final int modeVL1 = 7;
    public static final int modeVL2 = 8;
    public static final int modeVL3 = 9;
    private static final int[] Dim2dDict = new int[]{67073, 67330, 66819, 66569, 1, 2, 3, 67599, 4, 68108, 68368, 5, 68864, 69137, 6, 7, 8, 9};

    CCITT3d2Decomp(TiffNumberReader r, int aBitDirection) {
        super(r, aBitDirection);
    }

    public void begOfStrip() {
        this.bitOffset = 0;
    }

    public int findBitColorChange(int lineSize, int color, int bs) {
        int bitCount;
        int span;
        byte[] runs = this.invertOut_ ? (color == 0 ? oneRuns : zeroRuns) : (color == 0 ? zeroRuns : oneRuns);
        int bits = lineSize - bs;
        int bsIdx = bs >> 3;
        int bsBit = bs & 7;
        if (bits > 0 && bsBit != 0) {
            span = runs[this.LastLine[bsIdx] << bsBit & 0xFF];
            if (span > 8 - bsBit) {
                span = 8 - bsBit;
            }
            if (span > bits) {
                span = bits;
            }
            if (bsBit + span < 8) {
                return bs + span;
            }
            bits -= span;
            ++bsIdx;
        } else {
            span = 0;
        }
        while (bits >= 8) {
            bitCount = runs[this.LastLine[bsIdx++] & 0xFF];
            span += bitCount;
            bits -= bitCount;
            if (bitCount >= 8) continue;
            return bs + span;
        }
        if (bits > 0) {
            span += (bitCount = runs[this.LastLine[bsIdx++] & 0xFF]) > bits ? bits : bitCount;
        }
        return bs + span;
    }

    public int findB1(int A0, int bitLineSize, int A0Color) {
        int B1 = A0 + 1;
        if (B1 < bitLineSize) {
            int B1Color;
            if (A0 < 0) {
                B1Color = 0;
            } else if (this.invertOut_) {
                B1Color = 1;
                if ((this.LastLine[A0 >> 3] & bitMask_[A0 & 7]) != 0) {
                    B1Color = 0;
                }
            } else {
                B1Color = 0;
                if ((this.LastLine[A0 >> 3] & bitMask_[A0 & 7]) != 0) {
                    B1Color = 1;
                }
            }
            B1 = this.findBitColorChange(bitLineSize, B1Color, B1);
            if (B1 < bitLineSize) {
                if (this.invertOut_) {
                    B1Color = 1;
                    if ((this.LastLine[B1 >> 3] & bitMask_[B1 & 7]) != 0) {
                        B1Color = 0;
                    }
                } else {
                    B1Color = 0;
                    if ((this.LastLine[B1 >> 3] & bitMask_[B1 & 7]) != 0) {
                        B1Color = 1;
                    }
                }
                if (A0Color == B1Color) {
                    ++B1;
                    B1 = this.findBitColorChange(bitLineSize, A0Color, B1);
                }
            }
        }
        return B1;
    }

    public int decode2DWord() {
        int curNode = 0;
        int dictWord = Dim2dDict[0];
        do {
            this.byteSource = (this.bitOffset++ & 7) == 0 ? this.readByte() : (byte)(this.byteSource << 1);
        } while (0 != ((dictWord = Dim2dDict[curNode = 0 != (this.byteSource & 0x80) ? (dictWord & 0xFF00) >>> 8 : dictWord & 0xFF]) & 0x10000));
        return dictWord;
    }

    public void decodeLine(byte[] Dest, int numPixels) throws JimiException {
        if (this.LastLine == null || this.LastLine.length != Dest.length) {
            this.LastLine = new byte[Dest.length];
            if (this.invertOut_) {
                CCITT3d1Decomp.setArrayFF(this.LastLine);
            }
        }
        CCITT3d1Decomp.setArrayZero(Dest);
        int A0 = -1;
        byte curColor = 0;
        if (this.invertOut_) {
            while (A0 < numPixels) {
                int B1 = this.findB1(A0, numPixels, curColor);
                if (A0 == -1) {
                    A0 = 0;
                }
                int dictWord = this.decode2DWord();
                switch (dictWord) {
                    case 1: {
                        curColor = (byte)(curColor ^ 1);
                        ++B1;
                        B1 = this.findBitColorChange(numPixels, curColor, B1);
                        if (curColor == 1) {
                            this.outputBitRun(Dest, A0, B1 - A0);
                        }
                        A0 += B1 - A0;
                        break;
                    }
                    case 2: {
                        int runLen = this.getRunLength(curColor);
                        if (curColor == 0) {
                            this.outputBitRun(Dest, A0, runLen);
                        }
                        A0 += runLen;
                        curColor = (byte)(curColor ^ 1);
                        runLen = this.getRunLength(curColor);
                        if (curColor == 0) {
                            this.outputBitRun(Dest, A0, runLen);
                        }
                        A0 += runLen;
                        break;
                    }
                    case 3: {
                        if (curColor == 0) {
                            this.outputBitRun(Dest, A0, B1 - A0);
                        }
                        A0 += B1 - A0;
                        break;
                    }
                    case 4: {
                        if (curColor == 0) {
                            this.outputBitRun(Dest, A0, 1 + B1 - A0);
                        }
                        A0 += 1 + B1 - A0;
                        break;
                    }
                    case 5: {
                        if (curColor == 0) {
                            this.outputBitRun(Dest, A0, 2 + B1 - A0);
                        }
                        A0 += 2 + B1 - A0;
                        break;
                    }
                    case 6: {
                        if (curColor == 0) {
                            this.outputBitRun(Dest, A0, 3 + B1 - A0);
                        }
                        A0 += 3 + B1 - A0;
                        break;
                    }
                    case 7: {
                        if (curColor == 0) {
                            this.outputBitRun(Dest, A0, B1 - A0 - 1);
                        }
                        A0 += B1 - A0 - 1;
                        break;
                    }
                    case 8: {
                        if (curColor == 0) {
                            this.outputBitRun(Dest, A0, B1 - A0 - 2);
                        }
                        A0 += B1 - A0 - 2;
                        break;
                    }
                    case 9: {
                        if (curColor == 0) {
                            this.outputBitRun(Dest, A0, B1 - A0 - 3);
                        }
                        A0 += B1 - A0 - 3;
                    }
                }
                curColor = (byte)(curColor ^ 1);
            }
        } else {
            while (A0 < numPixels) {
                int B1 = this.findB1(A0, numPixels, curColor);
                if (A0 == -1) {
                    A0 = 0;
                }
                int dictWord = this.decode2DWord();
                switch (dictWord) {
                    case 1: {
                        curColor = (byte)(curColor ^ 1);
                        ++B1;
                        B1 = this.findBitColorChange(numPixels, curColor, B1);
                        if (curColor == 0) {
                            this.outputBitRun(Dest, A0, B1 - A0);
                        }
                        A0 += B1 - A0;
                        break;
                    }
                    case 2: {
                        int runLen = this.getRunLength(curColor);
                        if (curColor == 1) {
                            this.outputBitRun(Dest, A0, runLen);
                        }
                        A0 += runLen;
                        curColor = (byte)(curColor ^ 1);
                        runLen = this.getRunLength(curColor);
                        if (curColor == 1) {
                            this.outputBitRun(Dest, A0, runLen);
                        }
                        A0 += runLen;
                        break;
                    }
                    case 3: {
                        if (curColor == 1) {
                            this.outputBitRun(Dest, A0, B1 - A0);
                        }
                        A0 += B1 - A0;
                        break;
                    }
                    case 4: {
                        if (curColor == 1) {
                            this.outputBitRun(Dest, A0, 1 + B1 - A0);
                        }
                        A0 += 1 + B1 - A0;
                        break;
                    }
                    case 5: {
                        if (curColor == 1) {
                            this.outputBitRun(Dest, A0, 2 + B1 - A0);
                        }
                        A0 += 2 + B1 - A0;
                        break;
                    }
                    case 6: {
                        if (curColor == 1) {
                            this.outputBitRun(Dest, A0, 3 + B1 - A0);
                        }
                        A0 += 3 + B1 - A0;
                        break;
                    }
                    case 7: {
                        if (curColor == 1) {
                            this.outputBitRun(Dest, A0, B1 - A0 - 1);
                        }
                        A0 += B1 - A0 - 1;
                        break;
                    }
                    case 8: {
                        if (curColor == 1) {
                            this.outputBitRun(Dest, A0, B1 - A0 - 2);
                        }
                        A0 += B1 - A0 - 2;
                        break;
                    }
                    case 9: {
                        if (curColor == 1) {
                            this.outputBitRun(Dest, A0, B1 - A0 - 3);
                        }
                        A0 += B1 - A0 - 3;
                    }
                }
                curColor = (byte)(curColor ^ 1);
            }
        }
        System.arraycopy(Dest, 0, this.LastLine, 0, Dest.length);
    }
}

