/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tiff;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.decoder.tiff.TiffNumberReader;
import com.sun.jimi.core.util.JimiUtil;

class Decompressor {
    public static final int boNormal = 1;
    public static final int boReversed = 2;
    private byte[] bitOrder;
    private TiffNumberReader reader;
    int bitspersample_;
    private static final byte[][] reverseBytes = new byte[2][256];
    protected boolean invertOut_ = false;

    Decompressor(TiffNumberReader r, int abitOrder, int bitspersample) {
        this.bitOrder = reverseBytes[abitOrder - 1];
        this.reader = r;
        this.bitspersample_ = bitspersample;
    }

    Decompressor(TiffNumberReader r, int abitOrder) {
        this(r, abitOrder, 1);
    }

    public byte readByte() {
        return this.bitOrder[this.reader.readByte() & 0xFF];
    }

    public void setRowsPerStrip(int rows) {
    }

    public void decodeLine(byte[] Dest, int pixelsWidth) throws JimiException {
        switch (this.bitspersample_) {
            case 1: {
                int byteLen = pixelsWidth + 7 >> 3;
                byte[] buf = Dest;
                if (this.invertOut_) {
                    for (int i = 0; i < byteLen; ++i) {
                        buf[i] = ~this.readByte();
                    }
                } else {
                    for (int i = 0; i < byteLen; ++i) {
                        buf[i] = this.readByte();
                    }
                }
                break;
            }
            case 4: {
                int byteLen = pixelsWidth + 1 >> 1;
                byte[] buf = new byte[byteLen];
                if (this.invertOut_) {
                    for (int i = 0; i < byteLen; ++i) {
                        buf[i] = ~this.readByte();
                    }
                } else {
                    for (int i = 0; i < byteLen; ++i) {
                        buf[i] = this.readByte();
                    }
                }
                JimiUtil.expandPixels(this.bitspersample_, buf, Dest, pixelsWidth);
                break;
            }
            case 8: {
                int byteLen = pixelsWidth;
                byte[] buf = Dest;
                if (this.invertOut_) {
                    for (int i = 0; i < byteLen; ++i) {
                        buf[i] = ~this.readByte();
                    }
                } else {
                    for (int i = 0; i < byteLen; ++i) {
                        buf[i] = this.readByte();
                    }
                }
                break;
            }
        }
    }

    public void begOfPage() {
    }

    public void begOfStrip() {
    }

    public void setInvert(boolean invert) {
        this.invertOut_ = invert;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Decompressor.reverseBytes[0][i] = (byte)i;
            Decompressor.reverseBytes[1][i] = (byte)((i & 1) << 7 | (i & 2) << 5 | (i & 4) << 3 | (i & 8) << 1 | (i & 0x10) >>> 1 | (i & 0x20) >>> 3 | (i & 0x40) >>> 5 | (i & 0x80) >>> 7);
        }
    }
}

