/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tiff;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.decoder.tiff.CCITT3d1Decomp;
import com.sun.jimi.core.decoder.tiff.CCITT3d2Decomp;
import com.sun.jimi.core.decoder.tiff.CCITTClassFDecomp;
import com.sun.jimi.core.decoder.tiff.Decompressor;
import com.sun.jimi.core.decoder.tiff.IFD;
import com.sun.jimi.core.decoder.tiff.LZWDecomp;
import com.sun.jimi.core.decoder.tiff.Packbits;
import com.sun.jimi.core.decoder.tiff.TIFDecoder;
import com.sun.jimi.core.decoder.tiff.TIFField;
import com.sun.jimi.core.decoder.tiff.TiffNumberReader;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.SeekInputStream;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;

class IFDDecode {
    AdaptiveRasterImage ji;
    IFD ifd;
    SeekInputStream sis;
    int newsubfiletype;
    int imagewidth;
    int imagelength;
    short[] bitspersample;
    int compression;
    int photometricinterpretation;
    int[] stripoffsets;
    int samplesperpixel;
    int rowsperstrip;
    int[] stripbytecounts;
    float xres;
    float yres;
    int resolutionunit;
    short[] colormap;
    int planarconfiguration;
    int extrasamples;
    float ycbcrcoefficients;
    int ycbcrpositioning;
    int[] ycbcrsubsampling;
    int referenceblackwhite;
    int badfaxlines;
    int cleanfaxdata;
    int consecutivebadfaxlines;
    int tilewidth;
    int tilelength;
    int[] tilebytecounts;
    int[] tileoffsets;
    int fillorder;
    int orientation;
    int t4options;
    int t6options;
    int predictor;
    LZWDecomp lzwDecomp_;
    int stripsperimage;
    int tilesacross;
    int tilesdown;
    int tilesperimage;
    TIFDecoder decoder;
    byte[] spc_o_;

    IFDDecode(TIFDecoder decoder, AdaptiveRasterImage ji, SeekInputStream sis) throws IOException {
        this.initDefaults();
        this.ji = ji;
        this.sis = sis;
        this.decoder = decoder;
    }

    void decodeTags(IFD ifd) throws IOException {
        Enumeration enumeration = ifd.getFields();
        while (enumeration.hasMoreElements()) {
            TIFField tf = (TIFField)enumeration.nextElement();
            this.decodeField(tf);
        }
    }

    void decodeField(TIFField tf) throws IOException {
        switch (tf.id) {
            case 254: {
                this.newsubfiletype = tf.getInt(this.sis);
                break;
            }
            case 256: {
                this.imagewidth = tf.getInt(this.sis);
                break;
            }
            case 257: {
                this.imagelength = tf.getInt(this.sis);
                break;
            }
            case 258: {
                this.bitspersample = tf.getShortArray(this.sis);
                break;
            }
            case 259: {
                this.compression = tf.getInt(this.sis);
                break;
            }
            case 262: {
                this.photometricinterpretation = tf.getInt(this.sis);
                break;
            }
            case 273: {
                this.stripoffsets = tf.getIntArray(this.sis);
                break;
            }
            case 277: {
                this.samplesperpixel = tf.getInt(this.sis);
                break;
            }
            case 278: {
                this.rowsperstrip = tf.getInt(this.sis);
                break;
            }
            case 279: {
                this.stripbytecounts = tf.getIntArray(this.sis);
                break;
            }
            case 282: {
                this.xres = tf.getRational(this.sis);
                break;
            }
            case 283: {
                this.yres = tf.getRational(this.sis);
                break;
            }
            case 296: {
                this.resolutionunit = tf.getInt(this.sis);
                break;
            }
            case 320: {
                this.colormap = tf.getShortArray(this.sis);
                break;
            }
            case 284: {
                this.planarconfiguration = tf.getInt(this.sis);
                break;
            }
            case 338: {
                this.extrasamples = tf.getInt(this.sis);
                break;
            }
            case 529: {
                this.ycbcrcoefficients = tf.getRational(this.sis);
                break;
            }
            case 530: {
                this.ycbcrsubsampling = tf.getIntArray(this.sis);
                break;
            }
            case 531: {
                this.ycbcrpositioning = tf.getInt(this.sis);
                break;
            }
            case 326: {
                this.badfaxlines = tf.getInt(this.sis);
                break;
            }
            case 327: {
                this.cleanfaxdata = tf.getInt(this.sis);
                break;
            }
            case 328: {
                this.consecutivebadfaxlines = tf.getInt(this.sis);
                break;
            }
            case 322: {
                this.tilewidth = tf.getInt(this.sis);
                break;
            }
            case 323: {
                this.tilelength = tf.getInt(this.sis);
                break;
            }
            case 324: {
                this.tileoffsets = tf.getIntArray(this.sis);
                break;
            }
            case 325: {
                this.tilebytecounts = tf.getIntArray(this.sis);
                break;
            }
            case 266: {
                this.fillorder = tf.getInt(this.sis);
                break;
            }
            case 274: {
                this.orientation = tf.getInt(this.sis);
                break;
            }
            case 292: {
                this.t4options = tf.getInt(this.sis);
                break;
            }
            case 293: {
                this.t6options = tf.getInt(this.sis);
                break;
            }
            case 317: {
                this.predictor = tf.getInt(this.sis);
                break;
            }
        }
    }

    void initDefaults() {
        this.newsubfiletype = 0;
        this.bitspersample = new short[1];
        this.bitspersample[0] = 1;
        this.compression = 1;
        this.samplesperpixel = 1;
        this.rowsperstrip = -1;
        this.resolutionunit = 2;
        this.planarconfiguration = 1;
        this.tilewidth = 0;
        this.tilelength = 0;
        this.fillorder = 1;
        this.orientation = 1;
        this.t6options = 0;
        this.t4options = 0;
        this.predictor = 1;
    }

    ColorModel createPaleteColorModel() throws JimiException {
        int numColors = this.colormap.length / 3;
        byte[] red = new byte[numColors];
        byte[] green = new byte[numColors];
        byte[] blue = new byte[numColors];
        for (int i = 0; i < numColors; ++i) {
            red[i] = (byte)(this.colormap[i] >> 8);
            green[i] = (byte)(this.colormap[i + numColors] >> 8);
            blue[i] = (byte)(this.colormap[i + 2 * numColors] >> 8);
        }
        return new IndexColorModel(8, numColors, red, green, blue);
    }

    ColorModel createColorModel() throws JimiException {
        switch (this.photometricinterpretation) {
            case 0: {
                int bitMask = (1 << this.bitspersample[0]) - 1;
                return new DirectColorModel(this.bitspersample[0], bitMask, bitMask, bitMask);
            }
            case 1: {
                int bitMask = (1 << this.bitspersample[0]) - 1;
                return new DirectColorModel(this.bitspersample[0], bitMask, bitMask, bitMask);
            }
            case 3: {
                return this.createPaleteColorModel();
            }
            case 2: {
                if (this.samplesperpixel != 3 || this.bitspersample[0] != 8 || this.bitspersample[1] != 8 || this.bitspersample[2] != 8) {
                    throw new JimiException("RGB image not 3 x 8 bits");
                }
                return ColorModel.getRGBdefault();
            }
        }
        return null;
    }

    void decodeImage() throws JimiException, IOException {
        if (this.planarconfiguration == 2) {
            throw new JimiException("Seperate planar config not supported");
        }
        if (this.compression == 6 || this.compression == 7) {
            throw new JimiException("TIFF JPG format not supported");
        }
        if ((this.rowsperstrip & Integer.MIN_VALUE) != 0) {
            this.rowsperstrip = this.imagelength;
        }
        if (this.tilewidth == 0) {
            this.stripsperimage = (this.imagelength + this.rowsperstrip - 1) / this.rowsperstrip;
        } else {
            this.tilesacross = (this.imagewidth + this.tilewidth - 1) / this.tilewidth;
            this.tilesdown = (this.imagelength + this.tilelength - 1) / this.tilelength;
            this.tilesperimage = this.tilesacross * this.tilesdown;
            if (this.tileoffsets == null) {
                this.tileoffsets = this.stripoffsets;
                this.tilebytecounts = this.stripbytecounts;
            }
        }
        switch (this.photometricinterpretation) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                throw new JimiException("photometric MASK unsupported");
            }
            case 5: {
                throw new JimiException("photometric SEPERATED unsupported");
            }
            case 6: {
                throw new JimiException("photometric YCBCR unsupported");
            }
            case 8: {
                throw new JimiException("photometric CIELAB unsupported");
            }
            default: {
                throw new JimiException("Photometric Interpretation invalid " + this.photometricinterpretation);
            }
        }
        switch (this.orientation) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.ji.setSize(this.imagewidth, this.imagelength);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.ji.setSize(this.imagelength, this.imagewidth);
                this.ji.setHints(1);
                this.ji.setProperty("fixedaspect", Boolean.TRUE);
            }
        }
        this.ji.setProperty("xres", new Float(this.xres));
        this.ji.setProperty("yres", new Float(this.yres));
        ColorModel cm = this.createColorModel();
        this.ji.setColorModel(cm);
        this.ji.setPixels();
        if ((this.photometricinterpretation == 1 || this.photometricinterpretation == 0 || this.photometricinterpretation == 3) && this.samplesperpixel == 1) {
            if (this.tilewidth == 0) {
                this.decodeStrips();
            } else {
                this.decodeTiles();
            }
        } else if (this.compression == 1 || this.compression == 32773 || this.compression == 5) {
            if (this.tilewidth == 0) {
                this.decodeStrips();
            } else {
                this.decodeTiles();
            }
        } else {
            throw new JimiException("Unsupported compression " + this.compression);
        }
    }

    void decodeJPG() throws JimiException, IOException {
        short bitsPerSample = this.bitspersample[0];
        int totalLen = 0;
        int s = this.stripsperimage;
        while (--s >= 0) {
            totalLen += this.stripbytecounts[0];
        }
        byte[] totalBuf = new byte[totalLen];
        int offset = 0;
        for (s = 0; s < this.stripsperimage; ++s) {
            byte[] strip = new byte[this.stripbytecounts[s]];
            this.sis.seek(this.stripoffsets[s]);
            this.sis.readFully(strip, 0, this.stripbytecounts[s]);
            System.arraycopy(strip, 0, totalBuf, offset, this.stripbytecounts[s]);
            offset += this.stripbytecounts[s];
        }
    }

    int numRows(int i) {
        if (i == this.stripsperimage - 1) {
            int val = this.imagelength % this.rowsperstrip;
            return val != 0 ? val : this.rowsperstrip;
        }
        return this.rowsperstrip;
    }

    public int rowSize() {
        int scanline = this.bitspersample[0] * this.imagewidth;
        if (this.planarconfiguration == 1) {
            scanline *= this.samplesperpixel;
        }
        return (scanline + 7) / 8;
    }

    Decompressor createDecompressor(byte[] buf) throws JimiException {
        Decompressor dcmpr = null;
        TiffNumberReader rdr = new TiffNumberReader(buf);
        switch (this.compression) {
            case 1: {
                dcmpr = new Decompressor(rdr, this.fillorder, this.bitspersample[0]);
                break;
            }
            case 2: {
                dcmpr = new CCITT3d1Decomp(rdr, this.fillorder);
                break;
            }
            case 3: {
                dcmpr = new CCITTClassFDecomp(rdr, this.fillorder, (this.t4options & 4) != 0);
                break;
            }
            case 4: {
                dcmpr = new CCITT3d2Decomp(rdr, this.fillorder);
                break;
            }
            case 32773: {
                dcmpr = new Packbits(rdr, this.fillorder, this.bitspersample[0]);
                break;
            }
            case 5: {
                if (this.predictor == 2 && this.bitspersample[0] != 8) {
                    throw new JimiException("horizontal difference only supported for 8 bits currently");
                }
                if (this.lzwDecomp_ == null) {
                    this.lzwDecomp_ = new LZWDecomp(new ByteArrayInputStream(buf, 0, buf.length - 2), this.fillorder, this.bitspersample[0], this.predictor);
                } else {
                    this.lzwDecomp_.setInputStream(new ByteArrayInputStream(buf, 0, buf.length - 2));
                }
                dcmpr = this.lzwDecomp_;
            }
        }
        return dcmpr;
    }

    void decodeStrips() throws JimiException, IOException {
        int[] pixelBufI = null;
        byte[] pixelBuf = null;
        boolean startPage = true;
        short bitsPerSample = this.bitspersample[0];
        int row = 0;
        if (this.samplesperpixel != 1) {
            pixelBufI = new int[this.imagewidth];
            pixelBuf = new byte[this.imagewidth * this.samplesperpixel];
        } else {
            pixelBuf = bitsPerSample == 1 ? new byte[(this.imagewidth + 7) / 8] : new byte[this.imagewidth];
        }
        int max_strip_size = 0;
        for (int i = 0; i < this.stripsperimage; ++i) {
            if (this.stripbytecounts[i] <= max_strip_size) continue;
            max_strip_size = this.stripbytecounts[i];
        }
        byte[] strip = new byte[max_strip_size + 2];
        for (int s = 0; s < this.stripsperimage; ++s) {
            int k;
            int i;
            this.sis.seek(this.stripoffsets[s]);
            this.sis.readFully(strip, 0, this.stripbytecounts[s]);
            Decompressor dcmpr = this.createDecompressor(strip);
            dcmpr.setRowsPerStrip(this.rowsperstrip);
            if (this.photometricinterpretation == 0 && this.samplesperpixel == 1) {
                dcmpr.setInvert(true);
            }
            dcmpr.begOfStrip();
            if (startPage) {
                dcmpr.begOfPage();
            }
            startPage = false;
            if (this.samplesperpixel == 1) {
                if (bitsPerSample == 1) {
                    i = this.numRows(s);
                    while (--i >= 0) {
                        dcmpr.decodeLine(pixelBuf, this.imagewidth);
                        this.setPackedChannel_Oriented(row, pixelBuf);
                        this.decoder.setProgress(++row * 100 / this.imagelength);
                    }
                    continue;
                }
                i = this.numRows(s);
                while (--i >= 0) {
                    dcmpr.decodeLine(pixelBuf, pixelBuf.length);
                    if (this.compression == 5 && this.predictor == 2) {
                        for (k = 0; k < pixelBuf.length - 1; ++k) {
                            int n = k + 1;
                            pixelBuf[n] = (byte)(pixelBuf[n] + pixelBuf[k]);
                        }
                    }
                    this.setChannel_Oriented(0, row, pixelBuf);
                    this.decoder.setProgress(++row * 100 / this.imagelength);
                }
                continue;
            }
            i = this.numRows(s);
            while (--i >= 0) {
                dcmpr.decodeLine(pixelBuf, pixelBuf.length);
                if (this.compression == 5 && this.predictor == 2) {
                    for (k = 0; k < (pixelBuf.length - 1) / 3; ++k) {
                        int n = (k + 1) * 3;
                        pixelBuf[n] = (byte)(pixelBuf[n] + pixelBuf[k * 3]);
                        int n2 = (k + 1) * 3 + 1;
                        pixelBuf[n2] = (byte)(pixelBuf[n2] + pixelBuf[k * 3 + 1]);
                        int n3 = (k + 1) * 3 + 2;
                        pixelBuf[n3] = (byte)(pixelBuf[n3] + pixelBuf[k * 3 + 2]);
                    }
                }
                for (int j = 0; j < this.imagewidth; ++j) {
                    pixelBufI[j] = 0xFF000000 | (pixelBuf[j * 3] & 0xFF) << 16 | (pixelBuf[j * 3 + 1] & 0xFF) << 8 | pixelBuf[j * 3 + 2] & 0xFF;
                }
                this.setChannel_Oriented(row, pixelBufI);
                this.decoder.setProgress(++row * 100 / this.imagelength);
            }
        }
    }

    void decodeTiles() throws JimiException, IOException {
        short bitsPerSample = this.bitspersample[0];
        byte[] pixelBuf = null;
        int[] pixelBufI = null;
        boolean startPage = true;
        int baseTileXoff = 0;
        int baseTileYoff = 0;
        if (this.samplesperpixel != 1) {
            pixelBufI = new int[this.tilewidth];
            pixelBuf = new byte[this.tilewidth * this.samplesperpixel];
        } else {
            pixelBuf = bitsPerSample == 1 ? new byte[(this.tilewidth + 7) / 8] : new byte[this.tilewidth];
        }
        int max_tile_size = 0;
        for (int i = 0; i < this.tilesperimage; ++i) {
            if (this.tilebytecounts[i] <= max_tile_size) continue;
            max_tile_size = this.tilebytecounts[i];
        }
        byte[] tile = new byte[max_tile_size + 2];
        for (int t = 0; t < this.tilesperimage; ++t) {
            this.sis.seek(this.tileoffsets[t]);
            this.sis.readFully(tile, 0, this.tilebytecounts[t]);
            Decompressor dcmpr = this.createDecompressor(tile);
            if (this.photometricinterpretation == 0) {
                dcmpr.setInvert(true);
            }
            dcmpr.begOfStrip();
            if (startPage) {
                dcmpr.begOfPage();
            }
            startPage = false;
            int tileYoff = baseTileYoff;
            int i = this.tilelength;
            while (--i >= 0) {
                dcmpr.decodeLine(pixelBuf, pixelBuf.length);
                int clippedWidth = baseTileXoff + this.tilewidth > this.imagewidth ? this.imagewidth - baseTileXoff : this.tilewidth;
                if (tileYoff < this.imagelength) {
                    int k;
                    if (this.samplesperpixel == 1) {
                        if (bitsPerSample == 1) {
                            this.setPackedChannel_Oriented(baseTileXoff, tileYoff, clippedWidth, pixelBuf);
                        } else {
                            if (this.compression == 5 && this.predictor == 2) {
                                for (k = 0; k < pixelBuf.length - 1; ++k) {
                                    int n = k + 1;
                                    pixelBuf[n] = (byte)(pixelBuf[n] + pixelBuf[k]);
                                }
                            }
                            this.setChannel_Oriented(baseTileXoff, tileYoff, clippedWidth, pixelBuf);
                        }
                    } else {
                        if (this.compression == 5 && this.predictor == 2) {
                            for (k = 0; k < (pixelBuf.length - 1) / 3; ++k) {
                                int n = (k + 1) * 3;
                                pixelBuf[n] = (byte)(pixelBuf[n] + pixelBuf[k * 3]);
                                int n2 = (k + 1) * 3 + 1;
                                pixelBuf[n2] = (byte)(pixelBuf[n2] + pixelBuf[k * 3 + 1]);
                                int n3 = (k + 1) * 3 + 2;
                                pixelBuf[n3] = (byte)(pixelBuf[n3] + pixelBuf[k * 3 + 2]);
                            }
                        }
                        for (int j = 0; j < this.imagewidth; ++j) {
                            pixelBufI[j] = 0xFF000000 | (pixelBuf[j * 3] & 0xFF) << 16 | (pixelBuf[j * 3 + 1] & 0xFF) << 8 | pixelBuf[j * 3 + 2] & 0xFF;
                        }
                        this.setChannel_Oriented(baseTileXoff, tileYoff, clippedWidth, pixelBufI);
                    }
                    ++tileYoff;
                    continue;
                }
                i = 0;
            }
            if ((baseTileXoff += this.tilewidth) <= (this.tilesacross - 1) * this.tilewidth) continue;
            baseTileXoff = 0;
            baseTileYoff += this.tilelength;
        }
    }

    void setPackedChannel_Oriented(int x, int y, int w, byte[] pixels) throws JimiException {
        if (this.spc_o_ == null) {
            this.spc_o_ = new byte[pixels.length * 8];
        }
        JimiUtil.expandOneBitPixels(pixels, this.spc_o_, this.imagewidth);
        this.setChannel_Oriented(x, y, w, this.spc_o_);
    }

    void setPackedChannel_Oriented(int row, byte[] pixels) throws JimiException {
        if (this.orientation == 1) {
            this.ji.setPackedChannel(row, pixels);
        } else {
            if (this.spc_o_ == null) {
                this.spc_o_ = new byte[pixels.length * 8];
            }
            JimiUtil.expandOneBitPixels(pixels, this.spc_o_, this.imagewidth);
            this.setChannel_Oriented(0, row, this.spc_o_);
        }
    }

    void setChannel_Oriented(int x, int y, int w, byte[] pixels) throws JimiException {
        switch (this.orientation) {
            case 1: {
                this.ji.setChannel(0, x, y, w, 1, pixels, 0, 0);
                break;
            }
            case 2: {
                int jiWidth = this.ji.getWidth();
                int offset = 0;
                byte[] buf = new byte[w];
                int i = w;
                while (--i >= 0) {
                    buf[i] = pixels[offset++];
                }
                x = jiWidth - x - w;
                this.ji.setChannel(0, x, y, w, 1, buf, 0, 0);
                break;
            }
            case 3: {
                int jiHeight = this.ji.getHeight();
                y = jiHeight - y - 1;
                int jiWidth = this.ji.getWidth();
                byte[] buf = new byte[w];
                int offset = w;
                for (int i = 0; i < w; ++i) {
                    buf[i] = pixels[--offset];
                }
                x = jiWidth - x - w;
                this.ji.setChannel(0, x, y, w, 1, buf, 0, 0);
                break;
            }
            case 4: {
                int jiHeight = this.ji.getHeight();
                y = jiHeight - y - 1;
                this.ji.setChannel(0, x, y, w, 1, pixels, 0, 0);
                break;
            }
            case 5: {
                int jiHeight = this.ji.getWidth();
                y = jiHeight - y - 1;
                this.setChannel_RotateCW90(x, y, w, pixels);
                break;
            }
            case 6: {
                this.setChannel_RotateCW90(x, y, w, pixels);
                break;
            }
            case 7: {
                int jiWidth = this.ji.getHeight();
                int offset = 0;
                byte[] buf = new byte[w];
                int i = w;
                while (--i >= 0) {
                    buf[i] = pixels[offset++];
                }
                x = jiWidth - x - w;
                this.setChannel_RotateCW90(x, y, w, buf);
                break;
            }
            case 8: {
                int jiHeight = this.ji.getWidth();
                y = jiHeight - y - 1;
                int jiWidth = this.ji.getHeight();
                byte[] buf = new byte[w];
                int offset = w;
                for (int i = 0; i < w; ++i) {
                    buf[i] = pixels[--offset];
                }
                x = jiWidth - x - w;
                this.setChannel_RotateCW90(x, y, w, buf);
            }
        }
    }

    final void setChannel_RotateCW90(int x, int y, int w, byte[] pixels) throws JimiException {
        this.ji.setChannel(0, this.ji.getWidth() - y - 1, x, 1, w, pixels, 0, 1);
    }

    void setChannel_Oriented(int channel, int row, byte[] pixels) throws JimiException {
        switch (this.orientation) {
            case 1: {
                this.ji.setChannel(channel, row, pixels);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.setChannel_Oriented(0, row, this.ji.getWidth(), pixels);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.setChannel_Oriented(0, row, this.ji.getHeight(), pixels);
            }
        }
    }

    void setChannel_Oriented(int x, int y, int w, int[] pixels) throws JimiException {
        switch (this.orientation) {
            case 1: {
                this.ji.setChannel(x, y, w, 1, pixels, 0, 0);
                break;
            }
            case 2: {
                int jiWidth = this.ji.getWidth();
                int offset = 0;
                int[] buf = new int[w];
                int i = w;
                while (--i >= 0) {
                    buf[i] = pixels[offset++];
                }
                x = jiWidth - x - w;
                this.ji.setChannel(x, y, w, 1, buf, 0, 0);
                break;
            }
            case 3: {
                int jiHeight = this.ji.getHeight();
                y = jiHeight - y - 1;
                int jiWidth = this.ji.getWidth();
                int[] buf = new int[w];
                int offset = w;
                for (int i = 0; i < w; ++i) {
                    buf[i] = pixels[--offset];
                }
                x = jiWidth - x - w;
                this.ji.setChannel(x, y, w, 1, buf, 0, 0);
                break;
            }
            case 4: {
                int jiHeight = this.ji.getHeight();
                y = jiHeight - y - 1;
                this.ji.setChannel(x, y, w, 1, pixels, 0, 0);
                break;
            }
            case 5: {
                int jiHeight = this.ji.getWidth();
                y = jiHeight - y - 1;
                this.setChannel_RotateCW90(x, y, w, pixels);
                break;
            }
            case 6: {
                this.setChannel_RotateCW90(x, y, w, pixels);
                break;
            }
            case 7: {
                int jiWidth = this.ji.getHeight();
                int offset = 0;
                int[] buf = new int[w];
                int i = w;
                while (--i >= 0) {
                    buf[i] = pixels[offset++];
                }
                x = jiWidth - x - w;
                this.setChannel_RotateCW90(x, y, w, buf);
                break;
            }
            case 8: {
                int jiHeight = this.ji.getWidth();
                y = jiHeight - y - 1;
                int jiWidth = this.ji.getHeight();
                int[] buf = new int[w];
                int offset = w;
                for (int i = 0; i < w; ++i) {
                    buf[i] = pixels[--offset];
                }
                x = jiWidth - x - w;
                this.setChannel_RotateCW90(x, y, w, buf);
            }
        }
    }

    final void setChannel_RotateCW90(int x, int y, int w, int[] pixels) throws JimiException {
        this.ji.setChannel(this.ji.getWidth() - y - 1, x, 1, w, pixels, 0, 1);
    }

    void setChannel_Oriented(int row, int[] pixels) throws JimiException {
        switch (this.orientation) {
            case 1: {
                this.ji.setChannel(row, pixels);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.setChannel_Oriented(0, row, this.ji.getWidth(), pixels);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.setChannel_Oriented(0, row, this.ji.getHeight(), pixels);
            }
        }
    }
}

