/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tiff;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.decoder.tiff.Decompressor;
import com.sun.jimi.core.decoder.tiff.TiffNumberReader;
import com.sun.jimi.core.util.lzw.LZWDecompressor;
import java.io.IOException;
import java.io.InputStream;

class LZWDecomp
extends Decompressor {
    int bitsperpixel_;
    byte[] bitPackedBuf_ = null;
    InputStream in_;
    LZWDecompressor decomp_;
    int predictor_;

    LZWDecomp(InputStream in, int abitOrder, int bitspersample, int predictor) {
        super(new TiffNumberReader(new byte[1]), abitOrder, bitspersample);
        this.in_ = in;
        this.bitsperpixel_ = bitspersample;
        this.predictor_ = predictor;
        this.decomp_ = new LZWDecompressor(this.in_, 8, true);
    }

    public void setInputStream(InputStream in) {
        this.decomp_.setInputStream(in);
    }

    public void decodeLine(byte[] Dest, int pixelsWidth) throws JimiException {
        Thread.yield();
        try {
            switch (this.bitsperpixel_) {
                case 4: {
                    if (this.bitPackedBuf_ == null) {
                        this.bitPackedBuf_ = new byte[pixelsWidth + 1 >> 1];
                    }
                    int dLen = this.decomp_.decompress(this.bitPackedBuf_);
                    if (this.invertOut_) {
                        int i = this.bitPackedBuf_.length;
                        while (--i >= 0) {
                            this.bitPackedBuf_[i] = ~this.bitPackedBuf_[i];
                        }
                    }
                    System.arraycopy(this.bitPackedBuf_, 0, Dest, 0, this.bitPackedBuf_.length);
                    break;
                }
                case 1: 
                case 8: {
                    int dLen = this.decomp_.decompress(Dest);
                    if (!this.invertOut_) break;
                    int i = Dest.length;
                    while (--i >= 0) {
                        Dest[i] = ~Dest[i];
                    }
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new JimiException("error unpacking data:" + e);
        }
    }

    public void begOfPage() {
    }

    public void begOfStrip() {
    }
}

