/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tiff;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.decoder.tiff.Decompressor;
import com.sun.jimi.core.decoder.tiff.TiffNumberReader;
import com.sun.jimi.core.util.JimiUtil;

class Packbits
extends Decompressor {
    int bitsperpixel_;
    byte[] bitPackedBuf_ = null;

    Packbits(TiffNumberReader r, int abitOrder, int bitsperpixel) {
        super(r, abitOrder);
        this.bitsperpixel_ = bitsperpixel;
    }

    public void decodeLine(byte[] Dest, int pixelsWidth) throws JimiException {
        switch (this.bitsperpixel_) {
            case 4: {
                if (this.bitPackedBuf_ == null) {
                    this.bitPackedBuf_ = new byte[(pixelsWidth + 1) / 2];
                }
                if (this.invertOut_) {
                    this.unpackbitsInvert(this.bitPackedBuf_);
                } else {
                    this.unpackbits(this.bitPackedBuf_);
                }
                JimiUtil.expandPixels(this.bitsperpixel_, this.bitPackedBuf_, Dest, pixelsWidth);
                break;
            }
            case 1: 
            case 8: {
                if (this.invertOut_) {
                    this.unpackbitsInvert(Dest);
                    break;
                }
                this.unpackbits(Dest);
            }
        }
    }

    public void begOfPage() {
    }

    public void begOfStrip() {
    }

    public void unpackbits(byte[] outb) {
        int o = 0;
        o = 0;
        while (o < outb.length) {
            int b = this.readByte();
            if (b >= 0) {
                ++b;
                for (int j = 0; j < b; ++j) {
                    outb[o + j] = this.readByte();
                }
                o += b;
                continue;
            }
            if (b == -128) continue;
            byte rep = this.readByte();
            int end = o - b + 1;
            while (o < end) {
                outb[o] = rep;
                ++o;
            }
        }
    }

    public void unpackbitsInvert(byte[] outb) {
        int o = 0;
        o = 0;
        while (o < outb.length) {
            int b = this.readByte();
            if (b >= 0) {
                ++b;
                for (int j = 0; j < b; ++j) {
                    outb[o + j] = ~this.readByte();
                }
                o += b;
                continue;
            }
            if (b == -128) continue;
            byte rep = this.readByte();
            int end = o - b + 1;
            rep = ~rep;
            while (o < end) {
                outb[o] = rep;
                ++o;
            }
        }
    }
}

