/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tiff;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.UnsupportedFormatException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.tiff.IFD;
import com.sun.jimi.core.decoder.tiff.IFDDecode;
import com.sun.jimi.core.util.SeekInputStream;
import com.sun.jimi.util.ExpandableArray;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TIFDecoder
extends JimiDecoderBase {
    public final short TIF_SIG_BE = (short)19789;
    public final short TIF_SIG_LE = (short)18761;
    public final short TIF_VERSION = (short)42;
    public final short TIF_HEADER_SIZE = (short)8;
    private AdaptiveRasterImage ji;
    private InputStream in;
    private InputStream bufIn;
    private SeekInputStream sis;
    private int state;
    private short tifSignature;
    private short version;
    private int ifdOffset;
    int nextIFDoffset;
    ExpandableArray IFDs;

    public void initDecoder(InputStream in, AdaptiveRasterImage ji) throws JimiException {
        try {
            this.in = in;
            this.bufIn = in;
            DataInputStream dIn = new DataInputStream(this.bufIn);
            this.tifSignature = dIn.readShort();
            if (this.tifSignature != 18761 && this.tifSignature != 19789) {
                throw new UnsupportedFormatException("not a TIFF file");
            }
            this.sis = new SeekInputStream(this.tifSignature == 19789, this.bufIn, 2);
            this.version = this.sis.readShort();
            this.ifdOffset = this.sis.readInt();
            if (this.version != 42 || this.ifdOffset < 8) {
                throw new UnsupportedFormatException("invalid TIFF Version or TIFF Header size");
            }
            this.ji = ji;
            this.nextIFDoffset = this.ifdOffset;
            this.state = 8;
            this.IFDs = new ExpandableArray();
        }
        catch (IOException e) {
            throw new JimiException("IO Error reading TIFF header");
        }
    }

    public void skipImage() throws JimiException {
        try {
            IFD ifd = new IFD();
            ifd.read(this.nextIFDoffset, this.sis);
            this.nextIFDoffset = ifd.offset;
            if (this.nextIFDoffset == 0) {
                this.state &= 0xFFFFFFF7;
            }
        }
        catch (IOException e) {
            throw new JimiException("Read error");
        }
    }

    public boolean driveDecoder() throws JimiException {
        try {
            if (this.nextIFDoffset == 0) {
                throw new JimiException("No more images.");
            }
            IFD ifd = new IFD();
            ifd.read(this.nextIFDoffset, this.sis);
            this.nextIFDoffset = ifd.offset;
            this.state = this.nextIFDoffset == 0 ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
            this.IFDs.addElement(ifd);
            try {
                this.decode(ifd);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ji.addFullCoverage();
            this.state = 0;
            this.state |= 2;
            this.state |= 4;
            if (this.nextIFDoffset != 0) {
                this.state |= 8;
            }
        }
        catch (IOException e) {
            throw new JimiException("TIFF IO Error");
        }
        return false;
    }

    public void freeDecoder() throws JimiException {
        this.in = null;
        this.bufIn = null;
        this.sis = null;
        this.ji = null;
    }

    public int getState() {
        return this.state;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji;
    }

    public void decode(IFD ifd) throws JimiException, IOException {
        IFDDecode ifdD = new IFDDecode(this, this.ji, this.sis);
        ifdD.decodeTags(ifd);
        ifdD.decodeImage();
    }

    public int getCapabilities() {
        return 1;
    }
}

