/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tiff;

import com.sun.jimi.core.util.SeekInputStream;
import java.io.IOException;

class TIFField {
    public static final int BYTE = 1;
    public static final int ASCII = 2;
    public static final int SHORT = 3;
    public static final int LONG = 4;
    public static final int RATIONAL = 5;
    public static final int SBYTE = 6;
    public static final int UNDEFINE = 7;
    public static final int SSHORT = 8;
    public static final int SLONG = 9;
    public static final int SRATIONAL = 10;
    public static final int FLOAT = 11;
    public static final int DOUBLE = 12;
    public static final int[] dataWidths = new int[]{1, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    short id;
    short type;
    int count;
    int offset;
    public static final String[] typeNames = new String[]{"no value", "BYTE", "ASCII", "SHORT", "LONG", "RATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "FLOAT", "DOUBLE"};

    TIFField() {
    }

    public final void read(SeekInputStream sis) throws IOException {
        this.id = sis.readShort();
        this.type = sis.readShort();
        this.count = sis.readInt();
        if (this.count * dataWidths[this.type] > 4) {
            this.offset = sis.readInt();
        } else {
            switch (this.type) {
                case 1: 
                case 2: 
                case 6: 
                case 7: {
                    this.offset = sis.readUnsignedByte() << 24;
                    this.offset += sis.readUnsignedByte() << 16;
                    this.offset += sis.readUnsignedByte() << 8;
                    this.offset += sis.readUnsignedByte();
                    break;
                }
                case 3: 
                case 8: {
                    this.offset = sis.readUnsignedShort() << 16;
                    this.offset += sis.readUnsignedShort();
                    break;
                }
                default: {
                    this.offset = sis.readInt();
                }
            }
        }
    }

    public final boolean equals(int id) {
        return this.id == id;
    }

    public int getInt(SeekInputStream sis) throws IOException {
        int val = 0;
        boolean error = false;
        if (this.count == 1) {
            switch (this.type) {
                case 1: {
                    val = this.offset >> 24 & 0xFF;
                    break;
                }
                case 6: {
                    val = (byte)(this.offset >> 24 & 0xFF);
                    break;
                }
                case 3: {
                    val = this.offset >> 16 & 0xFFFF;
                    break;
                }
                case 8: {
                    val = (short)(this.offset >> 16 & 0xFFFF);
                    break;
                }
                case 4: {
                    val = this.offset;
                    break;
                }
                case 9: {
                    val = this.offset;
                    break;
                }
                default: {
                    error = true;
                    break;
                }
            }
        } else {
            error = true;
        }
        if (error) {
            throw new RuntimeException("wrong method " + this.toString());
        }
        return val;
    }

    public float getRational(SeekInputStream sis) throws IOException {
        long den;
        long num;
        sis.seek(this.offset);
        if (this.type == 5) {
            num = sis.readInt();
            if (num < 0L) {
                num &= 0xFFFFFFFFL;
            }
            if ((den = (long)sis.readInt()) < 0L) {
                den &= 0xFFFFFFFFL;
            }
        } else {
            num = sis.readInt();
            den = sis.readInt();
        }
        return num / den;
    }

    public float[] getRationalArray(SeekInputStream sis) throws IOException {
        float[] f = new float[this.count];
        sis.seek(this.offset);
        for (int i = 0; i < this.count; ++i) {
            long den;
            long num;
            if (this.type == 5) {
                num = sis.readInt();
                if (num < 0L) {
                    num &= 0xFFFFFFFFL;
                }
                if ((den = (long)sis.readInt()) < 0L) {
                    den &= 0xFFFFFFFFL;
                }
            } else {
                num = sis.readInt();
                den = sis.readInt();
            }
            f[i] = num / den;
        }
        return f;
    }

    public int[] getIntArray(SeekInputStream sis) throws IOException {
        int[] arr = new int[this.count];
        if (this.type == 1 || this.type == 6 || this.type == 3 || this.type == 8) {
            short[] s = this.getShortArray(sis);
            for (int i = 0; i < this.count; ++i) {
                arr[i] = s[i];
            }
        } else if (this.type == 4 || this.type == 9) {
            if (this.count == 1) {
                arr[0] = this.offset;
            } else {
                sis.seek(this.offset);
                for (int i = 0; i < this.count; ++i) {
                    arr[i] = sis.readInt();
                }
            }
        } else {
            throw new RuntimeException("wrong method " + this.toString());
        }
        return arr;
    }

    public short[] getShortArray(SeekInputStream sis) throws IOException {
        short[] arr = new short[this.count];
        if (this.type == 1 || this.type == 6) {
            byte[] b = this.getByteArray(sis);
            for (int i = 0; i < this.count; ++i) {
                arr[i] = b[i];
            }
        } else if (this.type == 3 || this.type == 8) {
            if (this.count <= 2) {
                if (this.count >= 1) {
                    arr[0] = (short)(this.offset >> 16 & 0xFFFF);
                }
                if (this.count >= 2) {
                    arr[1] = (short)(this.offset & 0xFFFF);
                }
            } else {
                sis.seek(this.offset);
                for (int i = 0; i < this.count; ++i) {
                    arr[i] = sis.readShort();
                }
            }
        } else {
            throw new RuntimeException("wrong method " + this.toString());
        }
        return arr;
    }

    public byte[] getByteArray(SeekInputStream sis) throws IOException {
        byte[] arr = new byte[this.count];
        if (this.type == 1 || this.type == 6) {
            if (this.count <= 4) {
                if (this.count >= 1) {
                    arr[0] = (byte)(this.offset >> 24 & 0xFF);
                }
                if (this.count >= 2) {
                    arr[1] = (byte)(this.offset >> 16 & 0xFF);
                }
                if (this.count >= 3) {
                    arr[2] = (byte)(this.offset >> 8 & 0xFF);
                }
                if (this.count == 4) {
                    arr[3] = (byte)(this.offset & 0xFF);
                }
            } else {
                sis.seek(this.offset);
                for (int i = 0; i < this.count; ++i) {
                    arr[i] = sis.readByte();
                }
            }
        } else {
            throw new RuntimeException("wrong method " + this.toString());
        }
        return arr;
    }

    String getString(SeekInputStream sis) throws IOException {
        byte[] b = this.getByteArray(sis);
        return new String(b, 0, 0, b.length - 1);
    }

    public String toString() {
        return " id " + this.id + " count " + this.count + " type (" + typeNames[this.type] + ") " + this.type + " offset " + this.offset;
    }
}

