/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.xbm;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.util.x11.XbmParser;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.io.InputStream;

public class XBMDecoder
extends JimiDecoderBase {
    protected XbmParser parser_;
    protected AdaptiveRasterImage jimiImage_;
    protected int state_;
    protected InputStream input_;
    protected byte[] pixels_;

    public void initDecoder(InputStream in, AdaptiveRasterImage ji) {
        this.parser_ = new XbmParser(in);
        this.jimiImage_ = ji;
        this.input_ = in;
        this.state_ = 0;
    }

    public boolean driveDecoder() throws JimiException {
        if (!this.parser_.parse()) {
            throw new JimiException("Image does not parse.");
        }
        this.xbmInitialize(this.parser_.getWidth(), this.parser_.getHeight(), this.parser_.getBitmap(), Color.black, Color.white, true);
        this.state_ = 4;
        this.jimiImage_.addFullCoverage();
        return false;
    }

    public int getState() {
        return this.state_;
    }

    public void freeDecoder() {
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.jimiImage_;
    }

    private void xbmInitialize(int w, int h, int[] bits, Color fg, Color bg, boolean trans) throws JimiException {
        int width = w;
        int height = h;
        byte[] colormap = new byte[6];
        int transIndex = -1;
        if (trans) {
            transIndex = 0;
            colormap[0] = -1;
            colormap[1] = -1;
            colormap[2] = -1;
        } else {
            colormap[0] = (byte)bg.getRed();
            colormap[1] = (byte)bg.getGreen();
            colormap[2] = (byte)bg.getBlue();
        }
        colormap[3] = (byte)fg.getRed();
        colormap[4] = (byte)fg.getGreen();
        colormap[5] = (byte)fg.getBlue();
        IndexColorModel colorModel = new IndexColorModel(8, 2, colormap, 0, false, transIndex);
        this.pixels_ = new byte[width * height];
        int index = 0;
        int byteIndex = 0;
        int jMax = width / 8;
        try {
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < jMax; ++j) {
                    byte bitByte = (byte)bits[byteIndex];
                    for (int k = 0; k < 8; ++k) {
                        int pixel = bitByte & 1 << k;
                        this.pixels_[index] = pixel != 0 ? (byte)1 : 0;
                        ++index;
                    }
                    ++byteIndex;
                }
            }
        }
        catch (Exception e) {
            throw new JimiException(e.getMessage());
        }
        this.jimiImage_.setSize(width, height);
        this.jimiImage_.setColorModel(colorModel);
        this.jimiImage_.setPixels();
        this.jimiImage_.setChannel(0, 0, 0, width, height, this.pixels_, 0, width);
        this.setProgress(100);
    }
}

