/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.xpm;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.util.x11.XpmParser;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.io.InputStream;

public class XPMDecoder
extends JimiDecoderBase {
    protected XpmParser parser_;
    protected AdaptiveRasterImage jimiImage_;
    protected int state_;

    public void initDecoder(InputStream in, AdaptiveRasterImage ji) {
        this.parser_ = new XpmParser(in);
        this.jimiImage_ = ji;
        this.state_ = 0;
    }

    public boolean driveDecoder() throws JimiException {
        try {
            if (!this.parser_.parse()) {
                throw new JimiException("Image does not parse.");
            }
            this.xpmInitialize(this.parser_.getWidth(), this.parser_.getHeight(), this.parser_.getPixmap(), this.parser_.getColorTable());
        }
        catch (JimiException e) {
            this.state_ = 1;
            throw e;
        }
        catch (RuntimeException e) {
            this.state_ = 1;
            throw new JimiException(e.getMessage());
        }
        this.state_ = 4;
        this.jimiImage_.addFullCoverage();
        return false;
    }

    public int getState() {
        return this.state_;
    }

    public void freeDecoder() {
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.jimiImage_;
    }

    protected void xpmInitialize(int w, int h, byte[] pixels, Color[] colorTable) throws JimiException {
        int nColors = colorTable.length;
        int cmSize = 3 * nColors;
        byte[] colormap = new byte[cmSize];
        int transIndex = -1;
        for (int i = 0; i < nColors; ++i) {
            if (colorTable[i] == null) {
                transIndex = i;
                continue;
            }
            colormap[3 * i] = (byte)colorTable[i].getRed();
            colormap[3 * i + 1] = (byte)colorTable[i].getGreen();
            colormap[3 * i + 2] = (byte)colorTable[i].getBlue();
        }
        IndexColorModel colorModel = new IndexColorModel(8, nColors, colormap, 0, false, transIndex);
        this.jimiImage_.setSize(w, h);
        this.jimiImage_.setColorModel(colorModel);
        this.jimiImage_.setPixels();
        this.jimiImage_.setChannel(0, 0, 0, w, h, pixels, 0, w);
    }
}

