/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.apf;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiSingleImageRasterEncoder;
import com.sun.jimi.core.encoder.apf.APFEncoderFactory;
import com.sun.jimi.core.raster.JimiRasterImage;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class APFEncoder
extends JimiSingleImageRasterEncoder {
    public void doEncodeImage(JimiRasterImage rasterImage, OutputStream output) throws JimiException, IOException {
        DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(output));
        this.writeHeader(rasterImage, dataOut);
        this.writeImageData(rasterImage, dataOut);
        dataOut.flush();
    }

    protected void writeHeader(JimiRasterImage rasterImage, DataOutputStream output) throws JimiException, IOException {
        output.write(APFEncoderFactory.FORMAT_SIGNATURE);
        output.writeInt(rasterImage.getWidth());
        output.writeInt(rasterImage.getHeight());
    }

    protected void writeImageData(JimiRasterImage rasterImage, DataOutputStream output) throws JimiException, IOException {
        int[] rowBuffer = new int[rasterImage.getWidth()];
        for (int row = 0; row < rasterImage.getHeight(); ++row) {
            rasterImage.getRowRGB(row, rowBuffer, 0);
            for (int column = 0; column < rasterImage.getWidth(); ++column) {
                output.writeInt(rowBuffer[column]);
            }
        }
    }
}

