/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.bmp;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.bmp.BMPEncoder;
import com.sun.jimi.core.encoder.bmp.BMPEncoderIfc;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.io.IOException;

public class BMP24Encoder
implements BMPEncoderIfc {
    public void encodeBMP(BMPEncoder encoder, AdaptiveRasterImage ji, LEDataOutputStream out) throws JimiException {
        try {
            int fileType = 19778;
            int scanLineSize = (ji.getWidth() * 24 + 31) / 32 * 4;
            int headerSize = 54;
            int fileSize = scanLineSize * ji.getHeight() + headerSize;
            out.writeShort(fileType);
            out.writeInt(fileSize);
            out.writeShort(0);
            out.writeShort(0);
            out.writeInt(headerSize);
            out.writeInt(40);
            out.writeInt(ji.getWidth());
            out.writeInt(ji.getHeight());
            out.writeShort(1);
            out.writeShort(24);
            out.writeInt(0);
            out.writeInt(scanLineSize * ji.getHeight());
            out.writeInt(0);
            out.writeInt(0);
            out.writeInt(0);
            out.writeInt(0);
            int width = ji.getWidth();
            int[] rowBuf = new int[width];
            int heightStop = ji.getHeight() - 1;
            int padValue = scanLineSize - ji.getWidth() * 3;
            byte[] outBuf = new byte[3 * width + padValue];
            ji.setRGBDefault(true);
            for (int i = heightStop; i > -1; --i) {
                ji.getChannel(i, rowBuf, 0);
                int idx = 3 * width;
                int j = width;
                while (--j >= 0) {
                    outBuf[--idx] = (byte)((rowBuf[j] & 0xFF0000) >> 16);
                    outBuf[--idx] = (byte)((rowBuf[j] & 0xFF00) >> 8);
                    outBuf[--idx] = (byte)(rowBuf[j] & 0xFF);
                }
                idx = 3 * width;
                int pad = padValue;
                while (--pad >= 0) {
                    outBuf[idx++] = 0;
                }
                out.write(outBuf);
                encoder.setProgress((heightStop - i) * 100 / heightStop);
            }
        }
        catch (IOException e) {
            throw new JimiException("BMP24Encoder encodeBMP() IOException encountered");
        }
    }
}

