/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.bmp;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.bmp.BMPEncoder;
import com.sun.jimi.core.encoder.bmp.BMPEncoderIfc;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.awt.image.IndexColorModel;
import java.io.IOException;

public class BMP8Encoder
implements BMPEncoderIfc {
    public void encodeBMP(BMPEncoder encoder, AdaptiveRasterImage ji, LEDataOutputStream out) throws JimiException {
        try {
            IndexColorModel model;
            int fileType = 19778;
            int scanLineSize = (ji.getWidth() * 8 + 31) / 32 * 4;
            int headerSize = 1078;
            int fileSize = scanLineSize * ji.getHeight() + headerSize;
            out.writeShort(fileType);
            out.writeInt(fileSize);
            out.writeShort(0);
            out.writeShort(0);
            out.writeInt(headerSize);
            out.writeInt(40);
            out.writeInt(ji.getWidth());
            out.writeInt(ji.getHeight());
            out.writeShort(1);
            out.writeShort(8);
            out.writeInt(0);
            out.writeInt(scanLineSize * ji.getHeight());
            out.writeInt(0);
            out.writeInt(0);
            out.writeInt(0);
            out.writeInt(0);
            try {
                model = (IndexColorModel)ji.getColorModel();
            }
            catch (ClassCastException cce) {
                throw new JimiException("BMP8 encoding requires an IndexColorModel.");
            }
            int palette_size = Math.max(256, model.getMapSize());
            byte[] reds = new byte[palette_size];
            byte[] greens = new byte[palette_size];
            byte[] blues = new byte[palette_size];
            model.getReds(reds);
            model.getGreens(greens);
            model.getBlues(blues);
            for (int i = 0; i < 256; ++i) {
                if (i < palette_size) {
                    out.writeByte(blues[i]);
                    out.writeByte(greens[i]);
                    out.writeByte(reds[i]);
                    out.writeByte(0);
                    continue;
                }
                out.writeInt(0);
            }
            int width = ji.getWidth();
            int heightStop = ji.getHeight() - 1;
            byte[] rowBuf = new byte[width];
            int padValue = scanLineSize - width;
            for (int i = heightStop; i > -1; --i) {
                ji.getChannel(0, i, rowBuf, 0);
                out.write(rowBuf);
                for (int pad = 0; pad < padValue; ++pad) {
                    out.write(0);
                }
                encoder.setProgress((heightStop - i) * 100 / heightStop);
            }
        }
        catch (IOException e) {
            throw new JimiException("BMP8Encoder encodeBMP() IOException encountered");
        }
    }
}

