/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.bmp;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.encoder.bmp.BMP24Encoder;
import com.sun.jimi.core.encoder.bmp.BMP8Encoder;
import com.sun.jimi.core.encoder.bmp.BMPEncoderIfc;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;

public class BMPEncoder
extends JimiEncoderBase
implements BMPEncoderIfc {
    private OutputStream out;
    private LEDataOutputStream LEbOut;
    private int state;

    public void initSpecificEncoder(OutputStream out, AdaptiveRasterImage ji) throws JimiException {
        this.out = out;
        this.LEbOut = new LEDataOutputStream(out);
        this.state = 0;
    }

    public boolean driveEncoder() throws JimiException {
        AdaptiveRasterImage ji = this.getJimiImage();
        this.encodeBMP(this, ji, this.LEbOut);
        this.state |= 2;
        try {
            this.LEbOut.flush();
            this.LEbOut.close();
        }
        catch (IOException e) {
            throw new JimiException("BMPEncoder driveEncoder() IO Exception encountered");
        }
        return false;
    }

    public void freeEncoder() throws JimiException {
        this.out = null;
        this.LEbOut = null;
        super.freeEncoder();
    }

    public int getState() {
        return this.state;
    }

    public void encodeBMP(BMPEncoder decoder, AdaptiveRasterImage ji, LEDataOutputStream out) throws JimiException {
        this.createEncoderForImage(ji).encodeBMP(this, ji, out);
    }

    protected BMPEncoderIfc createEncoderForImage(AdaptiveRasterImage image) {
        ColorModel cm = image.getColorModel();
        if (cm instanceof IndexColorModel && cm.getPixelSize() == 8) {
            return new BMP8Encoder();
        }
        return new BMP24Encoder();
    }
}

