/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.cur;

import com.sun.jimi.core.InvalidOptionException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.ico.ICOEncoder;
import com.sun.jimi.core.util.LEDataOutputStream;
import com.sun.jimi.util.ArrayEnumeration;
import com.sun.jimi.util.IntegerRange;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.Enumeration;

public class CUREncoder
extends ICOEncoder {
    private short xHotspot = 0;
    private short yHotspot = 0;
    static final String OPTION_XHOTSPOT = "hotspot location X";
    static final String OPTION_YHOTSPOT = "hotpost location Y";
    static final String[] OPTION_NAMES = new String[]{"hotspot location X", "hotpost location Y"};
    static final IntegerRange POSSIBLE_XHOTSPOT_VALUES;
    static final IntegerRange POSSIBLE_YHOTSPOT_VALUES;

    public CUREncoder() {
        this.TYPE_FLAG = (short)2;
    }

    protected void writeICOCURDIREntry(LEDataOutputStream destination, AdaptiveRasterImage anImage) throws JimiException, IOException {
        IndexColorModel cm;
        try {
            cm = (IndexColorModel)anImage.getColorModel();
        }
        catch (ClassCastException cce) {
            throw new JimiException("image/x-cur formats can only be created from palette images");
        }
        int mapSize = cm.getMapSize();
        if (mapSize > 256) {
            throw new JimiException("image/x-cur formats can only support palette with up to 256 colors");
        }
        int bitCount = this.computeBitCount(mapSize);
        int width = anImage.getWidth();
        int height = anImage.getHeight();
        if (width > 256 || height > 256) {
            throw new JimiException("image/x-cur formats can only encode images up to 256 x 256 pixels");
        }
        int imageSize = this.computeImageSize(mapSize, bitCount, width, height);
        destination.writeByte((byte)width);
        destination.writeByte((byte)height);
        destination.writeByte((byte)mapSize);
        destination.writeByte(0);
        destination.writeShort(this.xHotspot);
        destination.writeShort(this.yHotspot);
        int resourceSize = 40 + imageSize * bitCount / 8 + (int)Math.pow(2.0, bitCount);
        destination.writeInt(resourceSize);
        destination.writeInt(this.currentOffset);
        this.currentOffset += imageSize;
    }

    public void setHotspot(short x, short y) {
        this.xHotspot = x;
        this.yHotspot = y;
    }

    public Enumeration getPropertyNames() {
        return new ArrayEnumeration(OPTION_NAMES);
    }

    public Object getPossibleValuesForProperty(String name) {
        if (name.equalsIgnoreCase(OPTION_XHOTSPOT)) {
            return POSSIBLE_XHOTSPOT_VALUES;
        }
        if (name.equalsIgnoreCase(OPTION_YHOTSPOT)) {
            return POSSIBLE_YHOTSPOT_VALUES;
        }
        return null;
    }

    public void setProperty(String name, Object value) throws InvalidOptionException {
        short val = 0;
        try {
            val = (short)((Integer)value).intValue();
        }
        catch (ClassCastException cce) {
            throw new InvalidOptionException("Must specify a java.lang.Integer value");
        }
        if (name.equalsIgnoreCase(OPTION_XHOTSPOT)) {
            if (!POSSIBLE_XHOTSPOT_VALUES.isInRange(value)) {
                throw new InvalidOptionException("Value is out of range");
            }
            this.setHotspot(val, this.yHotspot);
        } else if (name.equalsIgnoreCase(OPTION_YHOTSPOT)) {
            if (!POSSIBLE_YHOTSPOT_VALUES.isInRange(value)) {
                throw new InvalidOptionException("Value is out of range");
            }
            this.setHotspot(this.xHotspot, val);
        } else {
            throw new InvalidOptionException("No such Option");
        }
    }

    public void clearProperties() {
        this.setHotspot((short)0, (short)0);
    }

    public String getPropertyDescription(String name) throws InvalidOptionException {
        if (name.equalsIgnoreCase(OPTION_XHOTSPOT)) {
            return "The location of the cursor's pointer along the X-axis";
        }
        if (name.equalsIgnoreCase(OPTION_YHOTSPOT)) {
            return "The location of the cursor's pointer along the Y-axis";
        }
        throw new InvalidOptionException("No such option");
    }

    static {
        POSSIBLE_YHOTSPOT_VALUES = POSSIBLE_XHOTSPOT_VALUES = new IntegerRange(0, 65536);
    }
}

