/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.ico;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;

public class ICOEncoder
extends JimiEncoderBase {
    protected static final int BMPINFOHEADER_SIZE = 40;
    private boolean isEncodingFirstImage = true;
    protected LEDataOutputStream destination;
    protected short TYPE_FLAG = 1;
    protected int stateFlag = 4;
    protected int currentOffset = 0;

    public void initSpecificEncoder(OutputStream out, AdaptiveRasterImage ji) {
        this.destination = new LEDataOutputStream(out);
    }

    public boolean driveEncoder() throws JimiException {
        AdaptiveRasterImage currentImage = this.getJimiImage();
        try {
            AdaptiveRasterImage[] jimi_image_array = new AdaptiveRasterImage[]{currentImage};
            this.writeICOCURDirectory(this.destination, jimi_image_array);
            this.writeDIBImage(this.destination, currentImage);
        }
        catch (IOException ioe) {
            this.stateFlag = 1;
            throw new JimiException(ioe.toString());
        }
        catch (JimiException je) {
            this.stateFlag = 1;
            throw je;
        }
        this.stateFlag = 2;
        return false;
    }

    public int getState() {
        return this.stateFlag;
    }

    public void freeEncoder() throws JimiException {
    }

    protected void writeICOCURDirectory(LEDataOutputStream destination, AdaptiveRasterImage[] images) throws JimiException, IOException {
        destination.writeShort(0);
        destination.writeShort(1);
        destination.writeShort((short)images.length);
        this.currentOffset = 6;
        this.currentOffset += images.length * 16;
        for (int i = 0; i < images.length; ++i) {
            this.writeICOCURDIREntry(destination, images[i]);
        }
    }

    protected void writeICOCURDIREntry(LEDataOutputStream destination, AdaptiveRasterImage anImage) throws JimiException, IOException {
        IndexColorModel cm;
        try {
            cm = (IndexColorModel)anImage.getColorModel();
        }
        catch (ClassCastException cce) {
            throw new JimiException("image/x-ico formats can only be created from palette images");
        }
        int mapSize = cm.getMapSize();
        if (mapSize > 256) {
            throw new JimiException("image/x-ico formats can only support palette with up to 256 colors");
        }
        int bitCount = this.computeBitCount(mapSize);
        int width = anImage.getWidth();
        int height = anImage.getHeight();
        if (width > 256 || height > 256) {
            throw new JimiException("image/x-ico formats can only encode images up to 256 x 256 pixels");
        }
        int imageSize = this.computeImageSize(mapSize, bitCount, width, height);
        destination.writeByte((byte)width);
        destination.writeByte((byte)height);
        destination.writeByte((byte)mapSize);
        destination.writeByte(0);
        destination.writeShort(0);
        destination.writeShort((short)bitCount);
        int resourceSize = 40 + imageSize * bitCount / 8 + (int)Math.pow(2.0, bitCount);
        destination.writeInt(resourceSize);
        destination.writeInt(this.currentOffset);
        this.currentOffset += imageSize;
    }

    protected void writeDIBImage(LEDataOutputStream destination, AdaptiveRasterImage ji) throws JimiException, IOException {
        IndexColorModel icm = (IndexColorModel)ji.getColorModel();
        int mapSize = icm.getMapSize();
        int bitCount = this.computeBitCount(mapSize);
        this.writeBitmapInfoHeader(destination, bitCount, mapSize, ji, icm);
        this.writeRGBQuads(destination, icm);
        this.writePixels(destination, bitCount, ji);
    }

    protected void writeBitmapInfoHeader(LEDataOutputStream destination, int bitCount, int mapSize, AdaptiveRasterImage ji, IndexColorModel icm) throws JimiException, IOException {
        int width = ji.getWidth();
        int height = ji.getHeight() * 2;
        int imageSize = this.computeImageSize(mapSize, bitCount, width, height);
        destination.writeInt(40);
        destination.writeInt(width);
        destination.writeInt(height);
        destination.writeShort(1);
        destination.writeShort((short)bitCount);
        destination.writeInt(0);
        destination.writeInt(imageSize);
        destination.writeInt(0);
        destination.writeInt(0);
        destination.writeInt(0);
        destination.writeInt(0);
    }

    protected void writeRGBQuads(LEDataOutputStream destination, IndexColorModel icm) throws JimiException, IOException {
        int mapSize = icm.getMapSize();
        int bitCount = this.computeBitCount(mapSize);
        int pad = (int)Math.pow(2.0, bitCount) - mapSize;
        byte[] red = new byte[mapSize];
        byte[] blue = new byte[mapSize];
        byte[] green = new byte[mapSize];
        icm.getReds(red);
        icm.getBlues(blue);
        icm.getGreens(green);
        for (int i = 0; i < mapSize; ++i) {
            destination.writeByte(blue[i]);
            destination.writeByte(green[i]);
            destination.writeByte(red[i]);
            destination.writeByte(0);
        }
        byte[] padbuff = new byte[4];
        for (int i = 0; i < pad; ++i) {
            destination.write(padbuff);
        }
    }

    protected void writePixels(LEDataOutputStream destination, int bitCount, AdaptiveRasterImage anImage) throws JimiException, IOException {
        block10: {
            int[] buff;
            int scansize;
            int height;
            block11: {
                block9: {
                    anImage.setRGBDefault(false);
                    height = anImage.getHeight();
                    scansize = anImage.getWidth();
                    buff = new int[scansize];
                    if (bitCount != 2) break block9;
                    for (int i = height - 1; i > -1; --i) {
                        anImage.getChannel(i, buff, 0);
                        for (int j = 0; j < scansize; ++j) {
                            byte t = (byte)(buff[j] << 6);
                            t = (byte)(t | (byte)(buff[++j] << 4));
                            t = (byte)(t | (byte)(buff[++j] << 2));
                            t = (byte)(t | (byte)buff[++j]);
                        }
                    }
                    byte[] pad = new byte[scansize / 4];
                    for (int i = 0; i < height; ++i) {
                        destination.write(pad);
                    }
                    break block10;
                }
                if (bitCount != 4) break block11;
                for (int i = height - 1; i > -1; --i) {
                    anImage.getChannel(i, buff, 0);
                    for (int j = 0; j < scansize; ++j) {
                        byte t = (byte)(buff[j] << 4);
                        t = (byte)(t | (byte)buff[++j]);
                        destination.writeByte(t);
                    }
                }
                byte[] pad = new byte[scansize / 2];
                for (int i = 0; i < height; ++i) {
                    destination.write(pad);
                }
                break block10;
            }
            if (bitCount != 8) break block10;
            for (int i = height - 1; i > -1; --i) {
                anImage.getChannel(i, buff, 0);
                for (int j = 0; j < scansize; ++j) {
                    destination.writeByte((byte)buff[j]);
                }
            }
            byte[] pad = new byte[scansize];
            for (int i = 0; i < height; ++i) {
                destination.write(pad);
            }
        }
    }

    protected int computeImageSize(int mapSize, int bitCount, int width, int height) {
        return width * height;
    }

    protected int computeBitCount(int mapSize) {
        if (mapSize <= 4) {
            return 2;
        }
        if (mapSize <= 16) {
            return 4;
        }
        return 8;
    }
}

