/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.jpg;

import com.sun.jimi.core.encoder.jpg.CompressInfo;
import com.sun.jimi.core.encoder.jpg.JpegComponentInfo;
import com.sun.jimi.core.encoder.jpg.util;

public class CompressSetup {
    public static final short MAX_COMPS_IN_SCAN = 4;
    public static final short DCTSIZE = 8;
    public static final short MAX_BLOCKS_IN_MCU = 10;
    public static final short BITS_IN_SAMPLE = 8;
    public static final short MAX_SAMP_FACTOR = 4;
    public static final byte CS_UNKNOWN = 0;
    public static final byte CS_GRAYSCALE = 1;
    public static final byte CS_RGB = 2;
    public static final byte CS_YCbCr = 3;

    static void interleaved_scan_setup(CompressInfo cinfo) {
        if (cinfo.comps_in_scan > 4) {
            util.errexit("Too many components for interleaved scan");
        }
        cinfo.MCUs_per_row = (cinfo.image_width + cinfo.max_h_samp_factor * 8 - 1) / (cinfo.max_h_samp_factor * 8);
        cinfo.MCU_rows_in_scan = (cinfo.image_height + cinfo.max_v_samp_factor * 8 - 1) / (cinfo.max_v_samp_factor * 8);
        cinfo.blocks_in_MCU = 0;
        block0: for (short ci = 0; ci < cinfo.comps_in_scan; ci = (short)(ci + 1)) {
            JpegComponentInfo comp = cinfo.cur_comp_info[ci];
            comp.MCU_width = comp.h_samp_factor;
            comp.MCU_height = comp.v_samp_factor;
            comp.MCU_blocks = (short)(comp.MCU_width * comp.MCU_height);
            comp.downsampled_width = util.roundUp(comp.true_comp_width, comp.MCU_width * 8);
            comp.downsampled_height = util.roundUp(comp.true_comp_height, comp.MCU_height * 8);
            short mcublks = comp.MCU_blocks;
            if (cinfo.blocks_in_MCU + mcublks > 10) {
                util.errexit("Sampling factors too large for interleaved scan");
            }
            while (true) {
                short s = mcublks;
                mcublks = (short)(s - 1);
                if (s <= 0) continue block0;
                short s2 = cinfo.blocks_in_MCU;
                cinfo.blocks_in_MCU = (short)(s2 + 1);
                cinfo.MCU_membership[s2] = ci;
            }
        }
    }

    static void noninterleaved_scan_setup(CompressInfo cinfo) {
        JpegComponentInfo comp = cinfo.cur_comp_info[0];
        comp.MCU_width = 1;
        comp.MCU_height = 1;
        comp.MCU_blocks = 1;
        comp.downsampled_width = util.roundUp(comp.true_comp_width, 8);
        comp.downsampled_height = util.roundUp(comp.true_comp_height, 8);
        cinfo.MCUs_per_row = comp.downsampled_width / 8;
        cinfo.MCU_rows_in_scan = comp.downsampled_height / 8;
        cinfo.blocks_in_MCU = 1;
        cinfo.MCU_membership[0] = 0;
    }

    public static void setCDefaults(CompressInfo cinfo) {
        cinfo.comp_info = null;
        cinfo.data_precision = (short)8;
        cinfo.jpeg_color_space = (short)3;
        cinfo.num_components = (short)3;
        cinfo.comps_in_scan = (short)3;
        cinfo.comp_info = new JpegComponentInfo[3];
        cinfo.comp_info[0] = new JpegComponentInfo();
        cinfo.comp_info[0].component_index = 0;
        cinfo.comp_info[0].component_id = 1;
        cinfo.comp_info[0].h_samp_factor = (short)2;
        cinfo.comp_info[0].v_samp_factor = (short)2;
        cinfo.comp_info[0].quant_tbl_no = 0;
        cinfo.comp_info[0].dc_tbl_no = 0;
        cinfo.comp_info[0].ac_tbl_no = 0;
        cinfo.comp_info[1] = new JpegComponentInfo();
        cinfo.comp_info[1].component_index = 1;
        cinfo.comp_info[1].component_id = (short)2;
        cinfo.comp_info[1].h_samp_factor = 1;
        cinfo.comp_info[1].v_samp_factor = 1;
        cinfo.comp_info[1].quant_tbl_no = 1;
        cinfo.comp_info[1].dc_tbl_no = 1;
        cinfo.comp_info[1].ac_tbl_no = 1;
        cinfo.comp_info[2] = new JpegComponentInfo();
        cinfo.comp_info[2].component_index = (short)2;
        cinfo.comp_info[2].component_id = (short)3;
        cinfo.comp_info[2].h_samp_factor = 1;
        cinfo.comp_info[2].v_samp_factor = 1;
        cinfo.comp_info[2].quant_tbl_no = 1;
        cinfo.comp_info[2].dc_tbl_no = 1;
        cinfo.comp_info[2].ac_tbl_no = 1;
        cinfo.cur_comp_info = new JpegComponentInfo[4];
        cinfo.cur_comp_info[0] = cinfo.comp_info[0];
        cinfo.cur_comp_info[1] = cinfo.comp_info[1];
        cinfo.cur_comp_info[2] = cinfo.comp_info[2];
        cinfo.interleave = true;
    }

    public static void setMDefaults(CompressInfo cinfo) {
        cinfo.jpeg_color_space = 1;
        cinfo.num_components = 1;
        cinfo.comp_info[0].h_samp_factor = 1;
        cinfo.comp_info[0].v_samp_factor = 1;
        cinfo.comps_in_scan = 1;
        cinfo.interleave = false;
    }

    public static void initial_setup(CompressInfo cinfo) {
        JpegComponentInfo comp;
        short ci;
        cinfo.max_h_samp_factor = 1;
        cinfo.max_v_samp_factor = 1;
        for (ci = 0; ci < cinfo.num_components; ci = (short)(ci + 1)) {
            comp = cinfo.comp_info[ci];
            if (comp.h_samp_factor <= 0 || comp.h_samp_factor > 4 || comp.v_samp_factor <= 0 || comp.v_samp_factor > 4) {
                util.errexit("Bogus sampling factors");
            }
            cinfo.max_h_samp_factor = (short)Math.max(cinfo.max_h_samp_factor, comp.h_samp_factor);
            cinfo.max_v_samp_factor = (short)Math.max(cinfo.max_v_samp_factor, comp.v_samp_factor);
        }
        for (ci = 0; ci < cinfo.num_components; ci = (short)(ci + 1)) {
            comp = cinfo.comp_info[ci];
            comp.true_comp_width = (cinfo.image_width * comp.h_samp_factor + cinfo.max_h_samp_factor - 1) / cinfo.max_h_samp_factor;
            comp.true_comp_height = (cinfo.image_height * comp.v_samp_factor + cinfo.max_v_samp_factor - 1) / cinfo.max_v_samp_factor;
        }
    }
}

