/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.jpg;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.jpg.CompressInfo;
import com.sun.jimi.core.encoder.jpg.Shared;

public class ConvertColor {
    protected Shared shared;
    short[][] pixel_row;
    int[] jiIntBuf_;
    byte[] jiBufByt;
    static final short CS_UNKNOWN = 0;
    static final short CS_GRAYSCALE = 1;
    static final short CS_RGB = 2;
    static final short CS_YCbCr = 3;
    static final short SCALEBITS = 16;
    static final int ONE_HALF = 32768;
    static final short MAXJSAMPLE = 256;
    int[] rgb_ycc_tab;
    static final int R_Y_OFF = 0;
    static final int G_Y_OFF = 256;
    static final int B_Y_OFF = 512;
    static final int R_CB_OFF = 768;
    static final int G_CB_OFF = 1024;
    static final int B_CB_OFF = 1280;
    static final int R_CR_OFF = 1280;
    static final int G_CR_OFF = 1536;
    static final int B_CR_OFF = 1792;
    static final int TABLE_SIZE = 2048;
    int row_idx_;

    public ConvertColor(Shared shared) {
        this.shared = shared;
    }

    public static int scaleToInt(double f) {
        return (int)(f * 65536.5);
    }

    public void rgb_ycc_init(CompressInfo cinfo) {
        this.pixel_row = new short[cinfo.input_components][cinfo.image_width];
        this.rgb_ycc_tab = new int[2048];
        for (int i = 0; i < 256; ++i) {
            this.rgb_ycc_tab[i + 0] = ConvertColor.scaleToInt(0.299) * i;
            this.rgb_ycc_tab[i + 256] = ConvertColor.scaleToInt(0.587) * i;
            this.rgb_ycc_tab[i + 512] = ConvertColor.scaleToInt(0.114) * i + 32768;
            this.rgb_ycc_tab[i + 768] = -ConvertColor.scaleToInt(0.16874) * i;
            this.rgb_ycc_tab[i + 1024] = -ConvertColor.scaleToInt(0.33126) * i;
            this.rgb_ycc_tab[i + 1280] = ConvertColor.scaleToInt(0.5) * i + 0x800000;
            this.rgb_ycc_tab[i + 1536] = -ConvertColor.scaleToInt(0.41869) * i;
            this.rgb_ycc_tab[i + 1792] = -ConvertColor.scaleToInt(0.08131) * i;
        }
        this.row_idx_ = 0;
        this.jiIntBuf_ = new int[cinfo.image_width];
    }

    void Patching_get_gray_row(CompressInfo cinfo, short[] pixel_row) throws JimiException {
        if (this.jiBufByt == null) {
            this.jiBufByt = new byte[cinfo.image_width];
        }
        cinfo.ji.getChannel(0, this.row_idx_, this.jiBufByt, 0);
        ++this.row_idx_;
        for (int col = 0; col < cinfo.image_width; ++col) {
            pixel_row[col] = this.jiBufByt[col];
        }
    }

    public void get_rgb_ycc_rows(CompressInfo cinfo, int rows_to_read, short[][][] image_data) throws JimiException {
        AdaptiveRasterImage ji = cinfo.ji;
        int rowEnd = this.row_idx_ + rows_to_read;
        int width = cinfo.image_width;
        int[] buf = this.jiIntBuf_;
        int[] rgb_ycc_tabL = this.rgb_ycc_tab;
        int rowSource = this.row_idx_;
        for (int row = 0; row < rows_to_read; ++row) {
            ji.getChannel(rowSource, buf, 0);
            for (int col = 0; col < width; ++col) {
                int val = buf[col];
                int r = val >> 16 & 0xFF;
                int g = val >> 8 & 0xFF;
                int b = val & 0xFF;
                image_data[0][row][col] = (short)(rgb_ycc_tabL[r + 0] + rgb_ycc_tabL[g + 256] + rgb_ycc_tabL[b + 512] >> 16);
                image_data[1][row][col] = (short)(rgb_ycc_tabL[r + 768] + rgb_ycc_tabL[g + 1024] + rgb_ycc_tabL[b + 1280] >> 16);
                image_data[2][row][col] = (short)(rgb_ycc_tabL[r + 1280] + rgb_ycc_tabL[g + 1536] + rgb_ycc_tabL[b + 1792] >> 16);
            }
            ++rowSource;
        }
        this.row_idx_ += rows_to_read;
    }

    public void get_grayscale_rows(CompressInfo cinfo, int rows_to_read, short[][][] image_data) throws JimiException {
        for (int row = 0; row < rows_to_read; ++row) {
            this.Patching_get_gray_row(cinfo, this.pixel_row[0]);
            for (int col = 0; col < cinfo.image_width; ++col) {
                image_data[0][row][col] = this.pixel_row[0][col];
            }
        }
    }
}

