/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.jpg;

import com.sun.jimi.core.encoder.jpg.CompressInfo;
import com.sun.jimi.core.encoder.jpg.HuffTbl;
import com.sun.jimi.core.encoder.jpg.JpegComponentInfo;
import com.sun.jimi.core.encoder.jpg.util;
import java.io.IOException;

public class HuffEncode {
    static final short DCTSIZE = 8;
    int huff_put_buffer;
    int huff_put_bits;
    byte[] output_buffer;
    int bytes_in_buffer;

    void init_huff_tbl(HuffTbl htbl) {
        int i;
        byte[] huffsize = new byte[257];
        short[] huffcode = new short[257];
        int p = 0;
        for (int l = 1; l <= 16; ++l) {
            for (i = 1; i <= htbl.bits[l]; ++i) {
                huffsize[p++] = (byte)l;
            }
        }
        huffsize[p] = 0;
        int lastp = p;
        int code = 0;
        int si = huffsize[0];
        p = 0;
        while (huffsize[p] != 0) {
            while (huffsize[p] == si) {
                huffcode[p++] = code;
                code = (short)(code + 1);
            }
            code = (short)(code << 1);
            ++si;
        }
        for (i = 0; i < htbl.ehufsi.length; ++i) {
            htbl.ehufsi[i] = 0;
        }
        for (p = 0; p < lastp; ++p) {
            htbl.ehufco[htbl.huffval[p]] = huffcode[p];
            htbl.ehufsi[htbl.huffval[p]] = huffsize[p];
        }
    }

    void flush_bytes(CompressInfo cinfo) {
        try {
            cinfo.output_file.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write_byte(CompressInfo cinfo, int b) {
        try {
            cinfo.output_file.writeByte(b);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void write_bits(CompressInfo cinfo, int code, int size) {
        int put_buffer = code;
        int put_bits = this.huff_put_bits;
        if (size == 0) {
            util.errexit("Missing Huffman code table entry");
        }
        put_buffer &= (1 << size) - 1;
        put_buffer <<= 24 - (put_bits += size);
        put_buffer |= this.huff_put_buffer;
        while (put_bits >= 8) {
            int c = put_buffer >> 16 & 0xFF;
            this.write_byte(cinfo, c);
            if (c == 255) {
                this.write_byte(cinfo, 0);
            }
            put_buffer <<= 8;
            put_bits -= 8;
        }
        this.huff_put_buffer = put_buffer;
        this.huff_put_bits = put_bits;
    }

    void flush_bits(CompressInfo cinfo) {
        this.write_bits(cinfo, 127, 7);
        this.huff_put_buffer = 0;
        this.huff_put_bits = 0;
    }

    void encode_one_block(CompressInfo cinfo, int[] block, HuffTbl dctbl, HuffTbl actbl) {
        int temp2 = block[0];
        int temp = temp2;
        if (temp < 0) {
            temp = -temp;
            --temp2;
        }
        int nbits = 0;
        while (temp != 0) {
            ++nbits;
            temp >>= 1;
        }
        this.write_bits(cinfo, dctbl.ehufco[nbits], dctbl.ehufsi[nbits]);
        if (nbits != 0) {
            this.write_bits(cinfo, (short)temp2, nbits);
        }
        int r = 0;
        for (int k = 1; k < 64; ++k) {
            temp = block[k];
            if (temp == 0) {
                ++r;
                continue;
            }
            while (r > 15) {
                this.write_bits(cinfo, actbl.ehufco[240], actbl.ehufsi[240]);
                r -= 16;
            }
            temp2 = temp;
            if (temp < 0) {
                temp = -temp;
                --temp2;
            }
            nbits = 1;
            while ((temp >>= 1) != 0) {
                ++nbits;
            }
            int i = (r << 4) + nbits;
            this.write_bits(cinfo, actbl.ehufco[i], actbl.ehufsi[i]);
            this.write_bits(cinfo, (short)temp2, nbits);
            r = 0;
        }
        if (r > 0) {
            this.write_bits(cinfo, actbl.ehufco[0], actbl.ehufsi[0]);
        }
    }

    void huff_init(CompressInfo cinfo) {
        this.huff_put_buffer = 0;
        this.huff_put_bits = 0;
        for (short ci = 0; ci < cinfo.comps_in_scan; ci = (short)(ci + 1)) {
            JpegComponentInfo comp = cinfo.cur_comp_info[ci];
            if (cinfo.dc_huff_tbl[comp.dc_tbl_no] == null || cinfo.ac_huff_tbl[comp.ac_tbl_no] == null) {
                util.errexit("Use of undefined Huffman table");
            }
            this.init_huff_tbl(cinfo.dc_huff_tbl[comp.dc_tbl_no]);
            this.init_huff_tbl(cinfo.ac_huff_tbl[comp.ac_tbl_no]);
            cinfo.last_dc_val[ci] = 0;
        }
    }

    void huff_encode(CompressInfo cinfo, int[][] MCU_data) {
        for (short blkn = 0; blkn < cinfo.blocks_in_MCU; blkn = (short)(blkn + 1)) {
            short ci = cinfo.MCU_membership[blkn];
            JpegComponentInfo comp = cinfo.cur_comp_info[ci];
            int temp = MCU_data[blkn][0];
            int[] nArray = MCU_data[blkn];
            nArray[0] = nArray[0] - cinfo.last_dc_val[ci];
            cinfo.last_dc_val[ci] = temp;
            this.encode_one_block(cinfo, MCU_data[blkn], cinfo.dc_huff_tbl[comp.dc_tbl_no], cinfo.ac_huff_tbl[comp.ac_tbl_no]);
        }
    }

    public void huff_term(CompressInfo cinfo) {
        this.flush_bits(cinfo);
        this.flush_bytes(cinfo);
    }
}

