/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.jpg;

import com.sun.jimi.core.InvalidOptionException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.OptionsObject;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.encoder.jpg.CompressInfo;
import com.sun.jimi.core.encoder.jpg.CompressSetup;
import com.sun.jimi.core.encoder.jpg.Sample;
import com.sun.jimi.core.encoder.jpg.Shared;
import com.sun.jimi.core.encoder.jpg.Write;
import com.sun.jimi.core.encoder.jpg.util;
import com.sun.jimi.core.options.JPGOptions;
import com.sun.jimi.util.ArrayEnumeration;
import com.sun.jimi.util.IntegerRange;
import java.awt.image.ColorModel;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public class JPGEncoder
extends JimiEncoderBase
implements OptionsObject {
    private int state;
    CompressInfo cinfo;
    OutputStream out;
    short[][][] sample_buf;
    short[][][] sampled_img = null;
    int fullwidth;
    int rows_in_mcu;
    int rows_to_get;
    int cur_pixel_row;
    int ci;
    public static final short CS_UNKNOWN = 0;
    public static final short CS_GRAYSCALE = 1;
    public static final short CS_RGB = 2;
    public static final short CS_YCbCr = 3;
    static final short DCTSIZE = 8;
    static final int DEFAULT_QUALITY = 75;
    int quality_ = 75;
    public Shared shared = new Shared();
    static final String QUALITY_OPTION_NAME = "quality";
    static final IntegerRange POSSIBLE_QUALITY_VALUES = new IntegerRange(0, 100);
    static final String[] PROPERTY_NAMES = new String[]{"quality"};

    void input_init(CompressInfo cinfo) {
        ColorModel cm = cinfo.ji.getColorModel();
        cinfo.in_color_space = (short)-1;
        if (cinfo.in_color_space == -1) {
            cinfo.input_components = (short)3;
            cinfo.in_color_space = (short)2;
            cinfo.ji.setRGBDefault(true);
        }
        cinfo.image_width = cinfo.ji.getWidth();
        cinfo.image_height = cinfo.ji.getHeight();
    }

    public void initSpecificEncoder(OutputStream out, AdaptiveRasterImage ji) throws JimiException {
        this.out = out;
        this.state = 0;
        if (ji.getOptions() instanceof JPGOptions) {
            this.quality_ = ((JPGOptions)ji.getOptions()).getQuality();
        }
    }

    void initCInfo() throws JimiException {
        this.cinfo = new CompressInfo(this.quality_);
        this.cinfo.output_file = new DataOutputStream(new BufferedOutputStream(this.out));
        this.cinfo.ji = this.getJimiImage();
        this.input_init(this.cinfo);
        CompressSetup.setCDefaults(this.cinfo);
        if (this.cinfo.in_color_space == 1) {
            CompressSetup.setMDefaults(this.cinfo);
        }
        CompressSetup.initial_setup(this.cinfo);
        if (this.cinfo.interleave) {
            CompressSetup.interleaved_scan_setup(this.cinfo);
        } else {
            CompressSetup.noninterleaved_scan_setup(this.cinfo);
        }
        this.fullwidth = util.roundUp(this.cinfo.image_width, this.cinfo.max_h_samp_factor * 8);
        this.rows_in_mcu = this.cinfo.max_v_samp_factor * 8;
        this.sample_buf = new short[this.cinfo.num_components][this.rows_in_mcu][this.fullwidth];
        this.sampled_img = new short[this.cinfo.num_components][this.rows_in_mcu][this.fullwidth];
        this.shared.convertColor.rgb_ycc_init(this.cinfo);
        this.shared.huffEncode.huff_init(this.cinfo);
    }

    public boolean driveEncoder() throws JimiException {
        this.initCInfo();
        Write.write_file_header(this.cinfo);
        Write.write_scan_header(this.cinfo);
        this.cur_pixel_row = 0;
        while (this.cur_pixel_row < this.cinfo.image_height) {
            this.rows_to_get = Math.min(this.rows_in_mcu, this.cinfo.image_height - this.cur_pixel_row);
            if (this.cinfo.num_components == 1) {
                this.shared.convertColor.get_grayscale_rows(this.cinfo, this.rows_to_get, this.sample_buf);
            } else if (this.cinfo.num_components == 3) {
                this.shared.convertColor.get_rgb_ycc_rows(this.cinfo, this.rows_to_get, this.sample_buf);
            }
            Sample.edge_expand(this.cinfo, this.cinfo.image_width, this.rows_to_get, this.fullwidth, this.rows_in_mcu, this.sample_buf);
            this.ci = 0;
            while (this.ci < this.cinfo.num_components) {
                Sample.downsample(this.cinfo, this.ci, this.cinfo.comp_info[this.ci].true_comp_width, this.cinfo.comp_info[this.ci].v_samp_factor * 8, this.sample_buf[this.ci], this.sampled_img[this.ci]);
                ++this.ci;
            }
            this.shared.mcu.extract_MCUs(this.cinfo, this.sampled_img, 1);
            this.cur_pixel_row += this.rows_in_mcu;
        }
        this.shared.huffEncode.huff_term(this.cinfo);
        Write.write_file_trailer(this.cinfo);
        this.state |= 2;
        return false;
    }

    public void freeEncoder() throws JimiException {
        this.sample_buf = null;
        this.sampled_img = null;
        this.cinfo.ji = null;
        this.cinfo = null;
        super.freeEncoder();
    }

    public int getState() {
        return this.state;
    }

    public OptionsObject getOptionsObject() {
        return this;
    }

    public Enumeration getPropertyNames() {
        return new ArrayEnumeration(PROPERTY_NAMES);
    }

    public Object getProperty(String key) {
        if (key.equalsIgnoreCase(QUALITY_OPTION_NAME)) {
            return new Integer(this.quality_);
        }
        return null;
    }

    public void setProperty(String key, Object val) throws InvalidOptionException {
        int value;
        if (key.equalsIgnoreCase(QUALITY_OPTION_NAME)) {
            try {
                value = (Integer)val;
            }
            catch (ClassCastException cce) {
                throw new InvalidOptionException("Value must be a java.lang.Integer");
            }
            if (!POSSIBLE_QUALITY_VALUES.isInRange(value)) {
                throw new InvalidOptionException("Value must be between " + POSSIBLE_QUALITY_VALUES.getLeastValue() + " and " + POSSIBLE_QUALITY_VALUES.getGreatestValue());
            }
        } else {
            throw new InvalidOptionException("No such option");
        }
        this.quality_ = value;
    }

    public Object getPossibleValuesForProperty(String name) throws InvalidOptionException {
        if (name.equalsIgnoreCase(QUALITY_OPTION_NAME)) {
            return POSSIBLE_QUALITY_VALUES;
        }
        throw new InvalidOptionException("No such option");
    }

    public String getPropertyDescription(String name) throws InvalidOptionException {
        if (name.equalsIgnoreCase(QUALITY_OPTION_NAME)) {
            return "A lower quality image is smaller, but has more information loss";
        }
        throw new InvalidOptionException("No such option");
    }

    public void clearProperties() {
        this.quality_ = 75;
    }
}

