/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.jpg;

import com.sun.jimi.core.encoder.jpg.CompressInfo;
import com.sun.jimi.core.encoder.jpg.Fwddct;
import com.sun.jimi.core.encoder.jpg.JpegComponentInfo;
import com.sun.jimi.core.encoder.jpg.Shared;

public class Mcu {
    Shared shared;
    static final short DCTSIZE = 8;
    static final short CENTERJSAMPLE = 128;
    static final short MAX_BLOCKS_IN_MCU = 10;
    static final short[] ZZ = new short[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};
    int[] block_ = new int[64];
    int[][] MCU_data_ = new int[10][64];

    public Mcu(Shared shared) {
        this.shared = shared;
    }

    void extract_block(short[][] input_data, int start_row, int start_col, int[] output_data, short[] quanttbl) {
        int[] block = this.block_;
        int pos = 0;
        int elemr = 8;
        while (--elemr >= 0) {
            int col = start_col;
            short[] input_data_row = input_data[start_row++];
            block[pos++] = input_data_row[col++] - 128;
            block[pos++] = input_data_row[col++] - 128;
            block[pos++] = input_data_row[col++] - 128;
            block[pos++] = input_data_row[col++] - 128;
            block[pos++] = input_data_row[col++] - 128;
            block[pos++] = input_data_row[col++] - 128;
            block[pos++] = input_data_row[col++] - 128;
            block[pos++] = input_data_row[col++] - 128;
        }
        Fwddct.fwd_dct(block);
        int i = 64;
        while (--i >= 0) {
            int temp = block[ZZ[i]];
            if (temp < 0) {
                temp = -temp;
                temp += quanttbl[i] >> 1;
                temp /= quanttbl[i];
                temp = -temp;
            } else {
                temp += quanttbl[i] >> 1;
                temp /= quanttbl[i];
            }
            output_data[i] = temp;
        }
    }

    void extract_MCUs(CompressInfo cinfo, short[][][] image_data, int num_mcu_rows) {
        int[][] MCU_data = this.MCU_data_;
        for (int mcurow = 0; mcurow < num_mcu_rows; ++mcurow) {
            for (int mcuindex = 0; mcuindex < cinfo.MCUs_per_row; ++mcuindex) {
                int blkn = 0;
                for (short ci = 0; ci < cinfo.comps_in_scan; ci = (short)(ci + 1)) {
                    short[][] image_data_ci = image_data[ci];
                    JpegComponentInfo comp = cinfo.cur_comp_info[ci];
                    short[] quanttbl = cinfo.quant_tbl[comp.quant_tbl_no];
                    for (short ypos = 0; ypos < comp.MCU_height; ypos = (short)(ypos + 1)) {
                        for (short xpos = 0; xpos < comp.MCU_width; xpos = (short)(xpos + 1)) {
                            this.extract_block(image_data_ci, (mcurow * comp.MCU_height + ypos) * 8, (mcuindex * comp.MCU_width + xpos) * 8, MCU_data[blkn], quanttbl);
                            blkn = (short)(blkn + 1);
                        }
                    }
                }
                this.shared.huffEncode.huff_encode(cinfo, MCU_data);
            }
        }
    }
}

