/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.pcx;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.encoder.pcx.RLEOutputStreamForPCX;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.awt.Toolkit;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PCXEncoder
extends JimiEncoderBase {
    OutputStream myOut;
    RLEOutputStreamForPCX dataOut;
    LEDataOutputStream LEDOut;
    private int nState;
    int nBitsPerPixel = 8;
    int nBitPlanes = 1;
    int nBytesPerLine = 0;
    int nPaletteType = 1;
    int nVersion = 5;
    AdaptiveRasterImage myJimiImage;
    protected int COLOR_MODEL = 0;

    public void initSpecificEncoder(OutputStream anOutputStream, AdaptiveRasterImage aJimiImage) throws JimiException {
        this.nState = 0;
        this.myOut = anOutputStream;
        if (aJimiImage.getColorModel() instanceof DirectColorModel) {
            this.nBitPlanes = 3;
            this.COLOR_MODEL = 1;
        }
        this.LEDOut = new LEDataOutputStream(new BufferedOutputStream(this.myOut));
        this.dataOut = new RLEOutputStreamForPCX(this.LEDOut);
    }

    public void writePcxHeader(LEDataOutputStream aDataOutStream, AdaptiveRasterImage aJimiImage) {
        byte[] padding = new byte[54];
        byte[] palette = new byte[48];
        byte[] zero = new byte[2];
        int Xstart = 0;
        boolean Ystart = false;
        int Xend = 0;
        int Yend = 0;
        int nWidth = aJimiImage.getWidth();
        int nHeight = aJimiImage.getHeight();
        int nBytesPerLine = nWidth;
        Xend = Xstart + nWidth - 1;
        Yend = Xstart + nHeight - 1;
        try {
            aDataOutStream.write(10);
            aDataOutStream.write((byte)this.nVersion);
            aDataOutStream.write(1);
            aDataOutStream.write((byte)this.nBitsPerPixel);
            aDataOutStream.writeShort(0);
            aDataOutStream.writeShort(0);
            aDataOutStream.writeShort(Xend);
            aDataOutStream.writeShort(Yend);
            aDataOutStream.writeShort(nWidth);
            aDataOutStream.writeShort(nHeight);
            if (this.COLOR_MODEL == 0) {
                IndexColorModel icm = (IndexColorModel)aJimiImage.getColorModel();
                palette = this.makePalette(icm, 16);
            }
            aDataOutStream.write(palette);
            aDataOutStream.write(0);
            aDataOutStream.write((byte)this.nBitPlanes);
            aDataOutStream.writeShort(nBytesPerLine);
            aDataOutStream.writeShort(this.nPaletteType);
            Toolkit MyToolkit = Toolkit.getDefaultToolkit();
            aDataOutStream.writeShort(MyToolkit.getScreenSize().width);
            aDataOutStream.writeShort(MyToolkit.getScreenSize().height);
            aDataOutStream.write(padding);
            aDataOutStream.flush();
        }
        catch (IOException e) {
            this.nState = 1;
        }
    }

    public byte[] makePalette(IndexColorModel icm, int nColors) {
        int paletteSize = nColors * 3;
        byte[] palette = new byte[paletteSize];
        ByteArrayOutputStream localOut = new ByteArrayOutputStream(paletteSize);
        int count = icm.getMapSize();
        byte[] red = new byte[count];
        byte[] green = new byte[count];
        byte[] blue = new byte[count];
        icm.getReds(red);
        icm.getGreens(green);
        icm.getBlues(blue);
        try {
            int i;
            int my_count = nColors < count ? nColors : count;
            for (i = 0; i < my_count; ++i) {
                localOut.write(red[i]);
                localOut.write(green[i]);
                localOut.write(blue[i]);
            }
            if (nColors > count) {
                for (i = 0; i < nColors - my_count; ++i) {
                    localOut.write(0);
                    localOut.write(0);
                    localOut.write(0);
                }
            }
            palette = localOut.toByteArray();
            localOut.close();
            localOut = null;
        }
        catch (IOException e) {
            this.nState = 1;
        }
        return palette;
    }

    public void writePcxImage(RLEOutputStreamForPCX aDataOutStream, AdaptiveRasterImage aJimiImage) throws JimiException {
        int nWidth = aJimiImage.getWidth();
        int nHeight = aJimiImage.getHeight();
        this.nBytesPerLine = nWidth + 1;
        byte[] buffer = new byte[this.nBytesPerLine];
        try {
            for (int i = 0; i < nHeight; ++i) {
                if (this.COLOR_MODEL == 0) {
                    aJimiImage.getChannel(0, i, buffer, 0);
                    aDataOutStream.write(buffer);
                } else {
                    aJimiImage.setRGBDefault(true);
                    aJimiImage.getChannel(1, i, buffer, 0);
                    aDataOutStream.write(buffer);
                    aJimiImage.getChannel(2, i, buffer, 0);
                    aDataOutStream.write(buffer);
                    aJimiImage.getChannel(3, i, buffer, 0);
                    aDataOutStream.write(buffer);
                }
                this.setProgress(i * 100 / nHeight);
            }
        }
        catch (IOException e) {
            this.nState = 1;
        }
    }

    public void writePcxFooter(LEDataOutputStream aDataOutStream, AdaptiveRasterImage aJimiImage) {
        byte[] palette = new byte[768];
        IndexColorModel icm = (IndexColorModel)aJimiImage.getColorModel();
        palette = this.makePalette(icm, 256);
        try {
            aDataOutStream.write(12);
            aDataOutStream.write(palette, 0, palette.length);
        }
        catch (IOException e) {
            this.nState = 1;
        }
    }

    public boolean driveEncoder() throws JimiException {
        AdaptiveRasterImage myJimiImage = this.getJimiImage();
        try {
            this.writePcxHeader(this.LEDOut, myJimiImage);
            this.writePcxImage(this.dataOut, myJimiImage);
            if (this.COLOR_MODEL == 0) {
                this.writePcxFooter(this.LEDOut, myJimiImage);
            }
            this.LEDOut.flush();
            this.dataOut.flush();
            this.myOut.flush();
            this.nState = 2;
        }
        catch (IOException e) {
            this.nState = 1;
        }
        return false;
    }

    public void freeEncoder() throws JimiException {
        this.myOut = null;
        this.dataOut = null;
        this.LEDOut = null;
        super.freeEncoder();
    }

    public int getState() {
        return this.nState;
    }
}

