/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.pcx;

import java.io.IOException;
import java.io.OutputStream;

public class RLEOutputStreamForPCX
extends OutputStream {
    protected static final byte ONEFLAG = -64;
    protected static final byte ZEROFLAG = 63;
    protected OutputStream out_;
    protected byte runValue_;
    protected boolean endOfLine = false;
    protected int runCount_;

    public RLEOutputStreamForPCX(OutputStream out) {
        this.out_ = out;
    }

    protected synchronized void compressBytes(byte[] data, int offset, int len) throws IOException {
        int max_length = len;
        int count = this.runCount_;
        byte runValue = this.runValue_;
        OutputStream out = this.out_;
        count = 0;
        runValue = data[offset];
        for (int idx = offset; idx < max_length; ++idx) {
            byte newValue = data[idx];
            if (newValue == runValue && count < 63 && idx != max_length - 1) {
                ++count;
                continue;
            }
            this.writeRun(count, runValue);
            runValue = newValue;
            count = 1;
        }
        this.runCount_ = count;
        this.runValue_ = runValue;
    }

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        this.compressBytes(data, offset, length);
    }

    public void write(int value) throws IOException {
        this.write(new byte[]{(byte)value});
    }

    public void flush() throws IOException {
        this.writeRun();
        this.runCount_ = 0;
        this.runValue_ = (byte)-1;
    }

    protected void writeRun(int run_count, byte value) throws IOException {
        byte count = (byte)run_count;
        count = (byte)(count | 0xFFFFFFC0);
        this.out_.write(count);
        this.out_.write(value);
    }

    protected void writeRun() throws IOException {
        this.writeRun(this.runCount_, this.runValue_);
    }
}

