/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.pict;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.Packbits;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataOutputStream;
import java.io.IOException;

class PICTWriter {
    public static final int PICT_PACKBITSRECT = 152;
    public static final int PICT_9A = 154;
    public static final int PICT_END = 255;
    public static final int PICT_CLIP_RGN = 1;
    public static final int PICT_BITSRECT = 144;
    static final int GRAYSCALE = 1;
    static final int PALETTE = 2;
    static final int RGB = 3;
    AdaptiveRasterImage ji_;
    DataOutputStream out_;
    short width_;
    short height_;
    short pixelSize_;
    short rowBytes_;
    short packType_;
    boolean compress_;
    JimiEncoderBase encoder_;
    int outputCount_;
    byte[] bufC_;

    PICTWriter(JimiEncoderBase encoder, AdaptiveRasterImage ji, DataOutputStream out) throws JimiException {
        this.ji_ = ji;
        this.out_ = out;
        this.encoder_ = encoder;
    }

    void writeHeaders() throws IOException {
        this.writeHeader();
        this.writeV2AdditionalHeader();
    }

    void writeImage() throws JimiException, IOException {
        int imageMode = -1;
        ColorModel cm = this.ji_.getColorModel();
        int width = this.ji_.getWidth();
        int height = this.ji_.getHeight();
        if (width > Short.MAX_VALUE || height > Short.MAX_VALUE) {
            throw new JimiException("PICT only saves images < 32767 in width or height");
        }
        this.width_ = (short)width;
        this.height_ = (short)height;
        if (cm instanceof DirectColorModel) {
            int pixelSize = cm.getPixelSize();
            DirectColorModel dcm = (DirectColorModel)cm;
            int redMask = dcm.getRedMask();
            int greenMask = dcm.getGreenMask();
            int blueMask = dcm.getBlueMask();
            if (pixelSize <= 8 && redMask == greenMask && greenMask == blueMask) {
                imageMode = 1;
                this.pixelSize_ = (short)pixelSize;
            }
        } else if (cm instanceof IndexColorModel) {
            imageMode = 2;
            this.pixelSize_ = (short)cm.getPixelSize();
        }
        if (imageMode == -1) {
            imageMode = 3;
            this.ji_.setRGBDefault(true);
            this.pixelSize_ = (short)32;
        }
        switch (imageMode) {
            case 1: {
                if (this.pixelSize_ == 1) {
                    this.rowBytes_ = (short)(this.width_ / 8 + (width % 8 != 0 ? 1 : 0));
                    break;
                }
            }
            case 2: {
                this.rowBytes_ = (short)(this.width_ * 8 / this.pixelSize_ + (width * 8 % this.pixelSize_ != 0 ? 1 : 0));
                break;
            }
            case 3: {
                this.rowBytes_ = (short)(3 * this.width_);
            }
        }
        boolean bl = this.compress_ = this.rowBytes_ >= 8 || this.pixelSize_ == 32;
        if (imageMode == 3) {
            this.out_.writeShort(154);
        } else if (this.compress_) {
            this.out_.writeShort(152);
        } else {
            this.out_.writeShort(144);
        }
        switch (imageMode) {
            case 1: {
                if (this.pixelSize_ == 1) {
                    this.out_.writeShort(this.rowBytes_);
                    this.writeBitmap();
                    this.writeSrcDestMode();
                    boolean zeroIsWhite = false;
                    this.writeBitmapImageData(zeroIsWhite);
                    break;
                }
            }
            case 2: {
                this.packType_ = 0;
                this.out_.writeShort(this.rowBytes_ | 0x8000);
                this.writePixmap();
                this.writeColorTable(cm);
                this.writeSrcDestMode();
                this.writeImageData();
                break;
            }
            case 3: {
                this.packType_ = (short)4;
                this.writePixmap9A();
                this.writeSrcDestMode();
                this.writeDirectImageData();
            }
        }
        this.out_.writeShort(255);
    }

    void writeBitmap() throws IOException {
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(this.height_);
        this.out_.writeShort(this.width_);
    }

    void writeSrcDestMode() throws IOException {
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(this.height_);
        this.out_.writeShort(this.width_);
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(this.height_);
        this.out_.writeShort(this.width_);
        this.out_.writeShort(0);
    }

    void writeBitmapImageData(boolean zeroIsWhite) throws JimiException, IOException {
        byte[] buf = new byte[this.width_];
        byte[] packedBuf = new byte[this.rowBytes_];
        boolean outputCount = false;
        for (int i = 0; i < this.height_; ++i) {
            this.ji_.getChannel(0, i, buf, 0);
            int len = JimiUtil.packPixels(1, buf, packedBuf);
            if (!zeroIsWhite) {
                int j = packedBuf.length;
                while (--j >= 0) {
                    packedBuf[j] = ~packedBuf[j];
                }
            }
            this.outputBufRow(packedBuf);
            this.encoder_.setProgress(i * 100 / this.height_);
        }
        this.outputEvenByteFlush();
    }

    void writePixmap() throws IOException {
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(this.height_);
        this.out_.writeShort(this.width_);
        this.out_.writeShort(0);
        this.out_.writeShort(this.packType_);
        this.out_.writeInt(0);
        this.out_.writeShort(72);
        this.out_.writeShort(0);
        this.out_.writeShort(72);
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(this.pixelSize_);
        this.out_.writeShort(1);
        this.out_.writeShort(this.pixelSize_);
        this.out_.writeInt(0);
        this.out_.writeInt(0);
        this.out_.writeInt(0);
    }

    void writeImageData() throws JimiException, IOException {
        byte[] buf = new byte[this.width_];
        byte[] packedBuf = new byte[this.rowBytes_];
        boolean outputCount = false;
        for (int i = 0; i < this.height_; ++i) {
            this.ji_.getChannel(0, i, buf, 0);
            int len = JimiUtil.packPixels(this.pixelSize_, buf, packedBuf);
            this.outputBufRow(packedBuf);
            this.encoder_.setProgress(i * 100 / this.height_);
        }
        this.outputEvenByteFlush();
    }

    void writePixmap9A() throws IOException {
        this.out_.writeInt(255);
        this.out_.writeShort(33568);
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(this.height_);
        this.out_.writeShort(this.width_);
        this.out_.writeShort(0);
        this.out_.writeShort(this.packType_);
        this.out_.writeInt(0);
        this.out_.writeShort(72);
        this.out_.writeShort(0);
        this.out_.writeShort(72);
        this.out_.writeShort(0);
        this.out_.writeShort(16);
        this.out_.writeShort(this.pixelSize_);
        this.out_.writeShort(3);
        this.out_.writeShort(8);
        this.out_.writeInt(0);
        this.out_.writeInt(0);
        this.out_.writeInt(0);
    }

    void writeDirectImageData() throws JimiException, IOException {
        byte[] buf = new byte[this.rowBytes_];
        for (int i = 0; i < this.height_; ++i) {
            int offset = 0;
            this.ji_.getChannel(16, i, buf, offset);
            this.ji_.getChannel(8, i, buf, offset += this.width_);
            this.ji_.getChannel(0, i, buf, offset += this.width_);
            this.outputBufRow(buf);
            this.encoder_.setProgress(i * 100 / this.height_);
        }
        this.outputEvenByteFlush();
    }

    void outputBufRow(byte[] buf) throws IOException {
        if (this.compress_) {
            if (this.bufC_ == null) {
                this.bufC_ = new byte[buf.length + 1 + buf.length / 8];
            }
            int len = Packbits.packbits(buf, this.bufC_);
            if (this.rowBytes_ > 250) {
                this.out_.writeShort(len);
            } else {
                this.out_.writeByte(len);
            }
            this.out_.write(this.bufC_, 0, len);
            this.outputCount_ += len;
        } else {
            this.out_.write(buf);
            this.outputCount_ += buf.length;
        }
    }

    void outputEvenByteFlush() throws IOException {
        if ((this.outputCount_ & 1) != 0) {
            this.out_.writeByte(0);
        }
    }

    void writeColorTable(ColorModel cm) throws IOException {
        if (cm instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)cm;
            int numColors = icm.getMapSize();
            this.out_.writeInt(0);
            this.out_.writeShort(0);
            this.out_.writeShort((short)numColors - 1);
            byte[] red = new byte[numColors];
            byte[] green = new byte[numColors];
            byte[] blue = new byte[numColors];
            icm.getReds(red);
            icm.getGreens(green);
            icm.getBlues(blue);
            for (int i = 0; i < numColors; ++i) {
                this.out_.writeShort(i);
                this.out_.writeShort((short)((red[i] & 0xFF) << 8 | red[i] & 0xFF));
                this.out_.writeShort((short)((green[i] & 0xFF) << 8 | green[i] & 0xFF));
                this.out_.writeShort((short)((blue[i] & 0xFF) << 8 | blue[i] & 0xFF));
            }
        } else {
            int pixelSize = cm.getPixelSize();
            int numColors = 1 << pixelSize;
            this.out_.writeInt(0);
            this.out_.writeShort(0);
            this.out_.writeShort((short)numColors - 1);
            for (int i = 0; i < numColors; ++i) {
                this.out_.writeShort(i);
                int red = cm.getRed(i);
                int green = cm.getGreen(i);
                int blue = cm.getBlue(i);
                this.out_.writeShort((short)(red << 8 | red));
                this.out_.writeShort((short)(green << 8 | green));
                this.out_.writeShort((short)(blue << 8 | blue));
            }
        }
    }

    void writeHeader() throws IOException {
        byte[] buf = new byte[64];
        int i = 8;
        while (--i >= 0) {
            this.out_.write(buf);
        }
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(this.ji_.getHeight());
        this.out_.writeShort(this.ji_.getWidth());
        this.out_.writeShort(17);
        this.out_.writeShort(767);
    }

    void writeV2AdditionalHeader() throws IOException {
        this.out_.writeShort(3072);
        this.out_.writeShort(65535);
        this.out_.writeShort(0);
        this.out_.writeInt(0x480000);
        this.out_.writeInt(0x480000);
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeShort(0);
        this.out_.writeInt(0);
    }
}

