/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.png;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;

class PNGChunkUtil {
    protected CRC32 crcEngine = new CRC32();

    PNGChunkUtil() {
    }

    int getCRC() {
        return (int)this.crcEngine.getValue();
    }

    void resetCRC() {
        this.crcEngine.reset();
    }

    void updateCRC(int d) {
        this.crcEngine.update((d & 0xFF000000) >> 24);
        this.crcEngine.update((d & 0xFF0000) >> 16);
        this.crcEngine.update((d & 0xFF00) >> 8);
        this.crcEngine.update(d & 0xFF);
    }

    void updateCRC(short d) {
        this.crcEngine.update((d & 0xFF00) >> 8);
        this.crcEngine.update(d & 0xFF);
    }

    void updateCRC(byte d) {
        this.crcEngine.update(d);
    }

    void updateCRC(byte[] d) {
        this.crcEngine.update(d, 0, d.length);
    }

    void updateCRC(byte[] d, int len) {
        this.crcEngine.update(d, 0, len);
    }

    void write(DataOutputStream out, byte[] id, byte[] data, int len) throws IOException {
        out.writeInt(len);
        out.write(id);
        out.write(data, 0, len);
        this.resetCRC();
        this.updateCRC(id);
        this.updateCRC(data, len);
        out.writeInt(this.getCRC());
    }
}

