/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.png;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.OptionsObject;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.encoder.png.PNGChunkUtil;
import com.sun.jimi.core.encoder.png.PNGConstants;
import com.sun.jimi.core.encoder.png.PNGOptionsObject;
import com.sun.jimi.core.encoder.png.PNGWrite;
import com.sun.jimi.core.encoder.png.png_chunk_ihdr;
import com.sun.jimi.core.encoder.png.png_chunk_plte;
import com.sun.jimi.core.encoder.png.png_chunk_trns;
import com.sun.jimi.core.options.PNGOptions;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PNGEncoder
extends JimiEncoderBase
implements PNGConstants {
    private OutputStream out;
    private BufferedOutputStream bOut;
    private DataOutputStream dOut;
    private int state;
    Boolean alpha = null;
    byte interlace = 0;
    int compression = 0;

    protected void initSpecificEncoder(OutputStream out, AdaptiveRasterImage ji) throws JimiException {
        this.out = out;
        this.bOut = new BufferedOutputStream(out);
        this.dOut = new DataOutputStream(this.bOut);
        this.state = 0;
        if (ji.getOptions() instanceof PNGOptions) {
            int compression = ((PNGOptions)ji.getOptions()).getCompressionType();
            switch (compression) {
                case 0: {
                    this.setCompression(0);
                    break;
                }
                case 2: {
                    this.setCompression(1);
                    break;
                }
                case 3: {
                    this.setCompression(9);
                    break;
                }
                default: {
                    this.setCompression(-1);
                    break;
                }
            }
        } else {
            this.setCompression(-1);
        }
    }

    public boolean driveEncoder() throws JimiException {
        AdaptiveRasterImage ji = this.getJimiImage();
        this.encodePNG(ji, this.dOut);
        this.state |= 2;
        try {
            this.dOut.flush();
        }
        catch (IOException e) {
            throw new JimiException("IOException");
        }
        return false;
    }

    public void freeEncoder() throws JimiException {
        this.out = null;
        this.bOut = null;
        super.freeEncoder();
    }

    public int getState() {
        return this.state;
    }

    private void encodePNG(AdaptiveRasterImage ji, DataOutputStream out) throws JimiException {
        try {
            PNGChunkUtil pcu = new PNGChunkUtil();
            png_chunk_ihdr ihdr = new png_chunk_ihdr(ji, pcu, this);
            png_chunk_plte plte = new png_chunk_plte(ji, pcu, this);
            png_chunk_trns trns = this.alpha != Boolean.FALSE ? new png_chunk_trns(ji, pcu, this) : null;
            PNGWrite pw = new PNGWrite(ji, ihdr, 8192, pcu, this);
            pw.png_write_sig(out);
            ihdr.write(out);
            plte.write(out);
            if (this.alpha != Boolean.FALSE) {
                trns.write(out);
            }
            pw.png_write_sbit(out);
            pw.writeImageData(out);
            pw.png_write_iend(out);
        }
        catch (IOException e) {
            throw new JimiException("IOException");
        }
    }

    public OptionsObject getOptionsObject() {
        return new PNGOptionsObject(this);
    }

    Boolean getAlpha() {
        return this.alpha;
    }

    public void setAlpha(Boolean val) {
        this.alpha = val;
    }

    byte getInterlace() {
        return this.interlace;
    }

    void setInterlace(byte valu) {
        this.interlace = valu;
    }

    void setFilter(byte valu) {
    }

    byte getFilter() {
        return 0;
    }

    void setCompression(int Comp) {
        this.compression = Comp;
    }

    int getCompression() {
        return this.compression;
    }
}

