/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.png;

import com.sun.jimi.core.InvalidOptionException;
import com.sun.jimi.core.OptionsObject;
import com.sun.jimi.core.encoder.png.PNGConstants;
import com.sun.jimi.core.encoder.png.PNGEncoder;
import com.sun.jimi.util.ArrayEnumeration;
import java.util.Enumeration;

class PNGOptionsObject
implements OptionsObject,
PNGConstants {
    PNGEncoder encoder;
    static final String ALPHA_OPTION_NAME = "alpha";
    static final String COMPRESSION_OPTION_NAME = "compression";
    static final String INTERLACE_OPTION_NAME = "interlace";
    static final String FILTER_OPTION_NAME = "filter";
    static final String[] OPTION_NAMES = new String[]{"alpha", "compression", "interlace", "filter"};
    static final Boolean[] POSSIBLE_ALPHA_OPTIONS = new Boolean[]{Boolean.TRUE, Boolean.FALSE, null};
    static final String COMPRESSION_NONE = "none";
    static final String COMPRESSION_DEFAULT = "default";
    static final String COMPRESSION_FAST = "fast";
    static final String COMPRESSION_MAX = "max";
    static final String[] POSSIBLE_COMPRESSION_OPTIONS = new String[]{"none", "fast", "default", "max"};
    static final String INTERLACE_NONE = "none";
    static final String INTERLACE_ADAM7 = "adam7";
    static final String[] POSSIBLE_INTERLACE_OPTIONS = new String[]{"none", "adam7"};
    static final String FILTER_NONE = "none";
    static final String FILTER_SUB = "sub";
    static final String FILTER_UP = "up";
    static final String FILTER_AVG = "average";
    static final String FILTER_PAETH = "paeth";
    static final String FILTER_ALL = "all";
    static final String[] POSSIBLE_FILTER_OPTIONS = new String[]{"none", "sub", "up", "average", "paeth", "all"};

    PNGOptionsObject(PNGEncoder encoder) {
        this.encoder = encoder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String key, Object val) throws InvalidOptionException {
        if (key.equalsIgnoreCase(COMPRESSION_OPTION_NAME)) {
            String value;
            try {
                value = (String)val;
            }
            catch (ClassCastException cce) {
                throw new InvalidOptionException("Not a valid option");
            }
            if (value.equalsIgnoreCase("none")) {
                this.encoder.setCompression(0);
                return;
            } else if (value.equalsIgnoreCase(COMPRESSION_FAST)) {
                this.encoder.setCompression(1);
                return;
            } else if (value.equalsIgnoreCase(COMPRESSION_MAX)) {
                this.encoder.setCompression(9);
                return;
            } else {
                if (!value.equalsIgnoreCase(COMPRESSION_DEFAULT)) throw new InvalidOptionException("Not a valid option");
                this.encoder.setCompression(-1);
            }
            return;
        }
        if (key.equalsIgnoreCase(INTERLACE_OPTION_NAME)) {
            String value = val.toString();
            if (value.equalsIgnoreCase("none")) {
                this.encoder.setInterlace((byte)0);
                return;
            } else {
                if (!value.equalsIgnoreCase(INTERLACE_ADAM7)) throw new InvalidOptionException("Not a valid option");
                this.encoder.setInterlace((byte)1);
            }
            return;
        } else if (key.equalsIgnoreCase(ALPHA_OPTION_NAME)) {
            if (val == null) {
                this.encoder.setAlpha(null);
                return;
            } else {
                try {
                    this.encoder.setAlpha((Boolean)val);
                    return;
                }
                catch (ClassCastException cce) {
                    throw new InvalidOptionException("Value must be a java.lang.Boolean");
                }
            }
        } else {
            if (!key.equalsIgnoreCase(FILTER_OPTION_NAME)) throw new InvalidOptionException("No such property");
            String value = val.toString();
            if (value.equalsIgnoreCase("none")) {
                this.encoder.setFilter((byte)0);
                return;
            } else if (value.equalsIgnoreCase(FILTER_SUB)) {
                this.encoder.setFilter((byte)1);
                return;
            } else if (value.equalsIgnoreCase(FILTER_AVG)) {
                this.encoder.setFilter((byte)3);
                return;
            } else if (value.equalsIgnoreCase(FILTER_UP)) {
                this.encoder.setFilter((byte)2);
                return;
            } else if (value.equalsIgnoreCase(FILTER_PAETH)) {
                this.encoder.setFilter((byte)4);
                return;
            } else {
                if (!value.equalsIgnoreCase(FILTER_ALL)) throw new InvalidOptionException("No such option");
                this.encoder.setFilter((byte)5);
            }
        }
    }

    public Enumeration getPropertyNames() {
        return new ArrayEnumeration(OPTION_NAMES);
    }

    public Object getPossibleValuesForProperty(String name) throws InvalidOptionException {
        if (name.equalsIgnoreCase(ALPHA_OPTION_NAME)) {
            return POSSIBLE_ALPHA_OPTIONS;
        }
        if (name.equalsIgnoreCase(COMPRESSION_OPTION_NAME)) {
            return POSSIBLE_COMPRESSION_OPTIONS;
        }
        if (name.equalsIgnoreCase(INTERLACE_OPTION_NAME)) {
            return POSSIBLE_INTERLACE_OPTIONS;
        }
        if (name.equalsIgnoreCase(FILTER_OPTION_NAME)) {
            return POSSIBLE_FILTER_OPTIONS;
        }
        throw new InvalidOptionException("No such option");
    }

    public void clearProperties() {
        this.encoder.setInterlace((byte)0);
        this.encoder.setAlpha(null);
        this.encoder.setCompression(0);
        this.encoder.setFilter((byte)0);
    }

    public Object getProperty(String key) {
        if (key.equalsIgnoreCase(INTERLACE_OPTION_NAME)) {
            byte val = this.encoder.getInterlace();
            if (val == 0) {
                return "none";
            }
            return INTERLACE_ADAM7;
        }
        if (key.equalsIgnoreCase(ALPHA_OPTION_NAME)) {
            return this.encoder.getAlpha();
        }
        if (key.equalsIgnoreCase(COMPRESSION_OPTION_NAME)) {
            byte val = (byte)this.encoder.getCompression();
            if (val == 0) {
                return "none";
            }
            if (val == 1) {
                return COMPRESSION_FAST;
            }
            if (val == 9) {
                return COMPRESSION_MAX;
            }
            return COMPRESSION_DEFAULT;
        }
        if (key.equalsIgnoreCase(FILTER_OPTION_NAME)) {
            byte val = this.encoder.getFilter();
            if (val == 0) {
                return "none";
            }
            if (val == 1) {
                return FILTER_SUB;
            }
            if (val == 3) {
                return FILTER_AVG;
            }
            if (val == 2) {
                return FILTER_UP;
            }
            if (val == 4) {
                return FILTER_PAETH;
            }
            return FILTER_ALL;
        }
        return null;
    }

    public String getPropertyDescription(String name) throws InvalidOptionException {
        if (name.equalsIgnoreCase(ALPHA_OPTION_NAME)) {
            return "An alpha channel is optional, a null value will let JIMI decide";
        }
        if (name.equalsIgnoreCase(COMPRESSION_OPTION_NAME)) {
            return "This option has no affect";
        }
        if (name.equalsIgnoreCase(INTERLACE_OPTION_NAME)) {
            return "Not currently implemented";
        }
        if (name.equalsIgnoreCase(FILTER_OPTION_NAME)) {
            return "Not currently implemented";
        }
        throw new InvalidOptionException("No such option");
    }
}

