/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.png;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.png.PNGChunkUtil;
import com.sun.jimi.core.encoder.png.PNGConstants;
import com.sun.jimi.core.encoder.png.PNGEncoder;
import com.sun.jimi.core.encoder.png.png_chunk_ihdr;
import com.sun.jimi.core.util.JimiUtil;
import java.awt.image.ColorModel;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.Deflater;

class PNGWrite
implements PNGConstants {
    AdaptiveRasterImage ji;
    png_chunk_ihdr ihdr;
    byte filtering;
    Deflater compress;
    byte[] zbuf;
    int zbufO;
    byte[] scanLine;
    byte[] filter_ = new byte[1];
    byte[] prevScanLine;
    PNGChunkUtil pcu;
    byte[] packedBuf_ = null;
    boolean zeroIsWhite_;
    PNGEncoder encoder;

    PNGWrite(AdaptiveRasterImage ji, png_chunk_ihdr ihdr, int bufSize, PNGChunkUtil pcu, PNGEncoder encoder) {
        this.ji = ji;
        this.ihdr = ihdr;
        this.pcu = pcu;
        this.filtering = encoder.getFilter();
        this.encoder = encoder;
        this.compress = new Deflater();
        this.zbuf = new byte[bufSize];
        this.compress.setStrategy(0);
        this.compress.setLevel(encoder.getCompression());
        if (ihdr.colorType == 2) {
            this.scanLine = new byte[ji.getWidth() * 3];
        } else if (ihdr.colorType == 6) {
            this.scanLine = new byte[ji.getWidth() * 4];
        } else if (ihdr.colorType == 0 || ihdr.colorType == 3) {
            this.scanLine = new byte[ji.getWidth()];
        }
        this.prevScanLine = new byte[this.scanLine.length];
        this.zeroIsWhite_ = false;
        ColorModel cm = ji.getColorModel();
    }

    void writeImageData(DataOutputStream out) throws JimiException, IOException {
        if (this.ihdr.colorType == 2 || this.ihdr.colorType == 6) {
            this.ji.setRGBDefault(true);
        }
        switch (this.ihdr.interlaceMethod) {
            case 0: {
                this.writeInterlaceNone(out);
                break;
            }
            case 1: {
                this.writeInterlaceAdam7(out);
            }
        }
    }

    void writeInterlaceNone(DataOutputStream out) throws JimiException, IOException {
        this.zbufO = 0;
        for (int row = 0; row < this.ji.getHeight(); ++row) {
            this.filter_[0] = 0;
            switch (this.ihdr.colorType) {
                case 2: {
                    this.ji.getChannelRGB(row, this.scanLine, 0);
                    break;
                }
                case 6: {
                    this.ji.getChannelRGBA(row, this.scanLine, 0);
                    break;
                }
                case 0: {
                    this.ji.getChannel(0, row, this.scanLine, 0);
                    if (!this.zeroIsWhite_) break;
                    int j = this.scanLine.length;
                    while (--j >= 0) {
                        this.scanLine[j] = ~this.scanLine[j];
                    }
                    break;
                }
                case 3: {
                    this.ji.getChannel(0, row, this.scanLine, 0);
                }
            }
            this.writeFindFilter(out);
            this.encoder.setProgress(row * 100 / this.ji.getHeight());
        }
        this.writeFinalize(out);
    }

    void writeInterlaceAdam7(DataOutputStream out) throws JimiException, IOException {
        throw new JimiException("writeImageData() does not support writing interlace PNGs yet");
    }

    void writeFindFilter(DataOutputStream out) throws JimiException, IOException {
        this.writeFilteredRow(out);
    }

    void writeFilteredRow(DataOutputStream out) throws JimiException, IOException {
        int numBytes;
        this.compress.setInput(this.filter_, 0, 1);
        do {
            numBytes = this.compress.deflate(this.zbuf, this.zbufO, this.zbuf.length - this.zbufO);
            this.zbufO += numBytes;
            if (this.zbufO != this.zbuf.length) continue;
            this.pcu.write(out, PNGConstants.png_IDAT, this.zbuf, this.zbufO);
            this.zbufO = 0;
        } while (!this.compress.needsInput());
        switch (this.ihdr.colorType) {
            case 0: 
            case 3: {
                if (this.packedBuf_ == null) {
                    int packedLen = this.ihdr.width * this.ihdr.bitDepth / 8 + (this.ihdr.width * this.ihdr.bitDepth % 8 != 0 ? 1 : 0);
                    this.packedBuf_ = new byte[packedLen];
                }
                JimiUtil.packPixels(this.ihdr.bitDepth, this.scanLine, this.packedBuf_);
                this.compress.setInput(this.packedBuf_, 0, this.packedBuf_.length);
                break;
            }
            default: {
                this.compress.setInput(this.scanLine, 0, this.scanLine.length);
            }
        }
        do {
            numBytes = this.compress.deflate(this.zbuf, this.zbufO, this.zbuf.length - this.zbufO);
            this.zbufO += numBytes;
            if (this.zbufO != this.zbuf.length) continue;
            this.pcu.write(out, PNGConstants.png_IDAT, this.zbuf, this.zbufO);
            this.zbufO = 0;
        } while (!this.compress.needsInput());
        byte[] t = this.prevScanLine;
        this.prevScanLine = this.scanLine;
        this.scanLine = t;
    }

    void writeFinalize(DataOutputStream out) throws JimiException, IOException {
        this.compress.finish();
        do {
            int numBytes = this.compress.deflate(this.zbuf, this.zbufO, this.zbuf.length - this.zbufO);
            this.zbufO += numBytes;
            if (!this.compress.finished() && this.zbufO != this.zbuf.length) continue;
            this.pcu.write(out, PNGConstants.png_IDAT, this.zbuf, this.zbufO);
            this.zbufO = 0;
        } while (!this.compress.finished());
        this.compress.reset();
    }

    void png_write_sig(DataOutputStream out) throws IOException {
        out.write(PNGConstants.png_sig);
    }

    void png_write_iend(DataOutputStream out) throws IOException {
        byte[] dummy = new byte[1];
        this.pcu.write(out, PNGConstants.png_IEND, dummy, 0);
    }

    void png_write_sbit(DataOutputStream out) throws IOException {
        ColorModel cm = this.ji.getColorModel();
        if (!(this.ihdr.colorType != 2 && this.ihdr.colorType != 6 || JimiUtil.isRGBDefault(cm))) {
            byte[] chanWidths = JimiUtil.getChannelWidths(cm);
            byte[] sBIT_data = new byte[4];
            sBIT_data[0] = chanWidths[1];
            sBIT_data[1] = chanWidths[2];
            sBIT_data[2] = chanWidths[3];
            if (this.ihdr.colorType == 2) {
                this.pcu.write(out, PNGConstants.png_sBIT, sBIT_data, 3);
            } else if (this.ihdr.colorType == 6) {
                sBIT_data[3] = chanWidths[0];
                this.pcu.write(out, PNGConstants.png_sBIT, sBIT_data, 4);
            }
        }
    }
}

