/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.png;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.png.PNGChunkUtil;
import com.sun.jimi.core.encoder.png.PNGConstants;
import com.sun.jimi.core.encoder.png.PNGEncoder;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataOutputStream;
import java.io.IOException;

class png_chunk_ihdr
implements PNGConstants {
    int width;
    int height;
    byte bitDepth;
    byte colorType;
    byte compressionType;
    byte filterMethod;
    byte interlaceMethod;
    PNGChunkUtil pcu;

    png_chunk_ihdr(AdaptiveRasterImage ji, PNGChunkUtil pcu, PNGEncoder encoder) throws JimiException {
        this.width = ji.getWidth();
        this.height = ji.getHeight();
        this.process(ji, encoder);
        this.compressionType = 0;
        this.filterMethod = encoder.getFilter();
        this.interlaceMethod = encoder.getInterlace();
        this.pcu = pcu;
    }

    void process(AdaptiveRasterImage ji, PNGEncoder encoder) throws JimiException {
        ColorModel cm = ji.getColorModel();
        this.colorType = (byte)-1;
        if (cm instanceof DirectColorModel) {
            DirectColorModel dCM = (DirectColorModel)cm;
            int rMask = dCM.getRedMask();
            int gMask = dCM.getGreenMask();
            int bMask = dCM.getBlueMask();
            int pixelSize = dCM.getPixelSize();
            int fullMask = (1 << pixelSize) - 1;
            if (pixelSize <= 8 && rMask == fullMask && gMask == fullMask && bMask == fullMask) {
                this.bitDepth = (byte)cm.getPixelSize();
                this.colorType = 0;
            }
        } else if (cm instanceof IndexColorModel) {
            this.bitDepth = (byte)cm.getPixelSize();
            this.colorType = (byte)3;
        }
        if (this.colorType == -1) {
            ji.setRGBDefault(true);
            this.bitDepth = (byte)8;
            Boolean pngAlpha = encoder.getAlpha();
            this.colorType = pngAlpha == null ? (ji.getAlphaStatus() == 1 ? (byte)6 : (byte)2) : (pngAlpha.equals(Boolean.TRUE) ? (byte)6 : (byte)2);
        }
    }

    void write(DataOutputStream out) throws IOException {
        out.writeInt(13);
        out.write(PNGConstants.png_IHDR);
        out.writeInt(this.width);
        out.writeInt(this.height);
        out.writeByte(this.bitDepth);
        out.writeByte(this.colorType);
        out.writeByte(this.compressionType);
        out.writeByte(this.filterMethod);
        out.writeByte(this.interlaceMethod);
        this.pcu.resetCRC();
        this.pcu.updateCRC(PNGConstants.png_IHDR);
        this.pcu.updateCRC(this.width);
        this.pcu.updateCRC(this.height);
        this.pcu.updateCRC(this.bitDepth);
        this.pcu.updateCRC(this.colorType);
        this.pcu.updateCRC(this.compressionType);
        this.pcu.updateCRC(this.filterMethod);
        this.pcu.updateCRC(this.interlaceMethod);
        out.writeInt(this.pcu.getCRC());
    }
}

