/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.png;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.png.PNGChunkUtil;
import com.sun.jimi.core.encoder.png.PNGConstants;
import com.sun.jimi.core.encoder.png.PNGEncoder;
import java.awt.image.IndexColorModel;
import java.io.DataOutputStream;
import java.io.IOException;

class png_chunk_plte
implements PNGConstants {
    byte[] reds;
    byte[] greens;
    byte[] blues;
    int mapSize;
    IndexColorModel cm = null;
    PNGChunkUtil pcu;

    png_chunk_plte(AdaptiveRasterImage ji, PNGChunkUtil pcu, PNGEncoder encoder) throws JimiException {
        if (ji.getColorModel() instanceof IndexColorModel) {
            this.cm = (IndexColorModel)ji.getColorModel();
            this.mapSize = this.cm.getMapSize();
            this.reds = new byte[this.mapSize];
            this.greens = new byte[this.mapSize];
            this.blues = new byte[this.mapSize];
            this.cm.getReds(this.reds);
            this.cm.getBlues(this.blues);
            this.cm.getGreens(this.greens);
        }
        this.pcu = pcu;
    }

    void write(DataOutputStream out) throws IOException {
        if (this.cm != null) {
            out.writeInt(this.mapSize * 3);
            out.write(PNGConstants.png_PLTE);
            this.pcu.resetCRC();
            this.pcu.updateCRC(PNGConstants.png_PLTE);
            for (int i = 0; i < this.mapSize; ++i) {
                out.writeByte(this.reds[i]);
                out.writeByte(this.greens[i]);
                out.writeByte(this.blues[i]);
                this.pcu.updateCRC(this.reds[i]);
                this.pcu.updateCRC(this.greens[i]);
                this.pcu.updateCRC(this.blues[i]);
            }
            out.writeInt(this.pcu.getCRC());
        }
    }
}

