/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.png;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.png.PNGChunkUtil;
import com.sun.jimi.core.encoder.png.PNGConstants;
import com.sun.jimi.core.encoder.png.PNGEncoder;
import java.awt.image.IndexColorModel;
import java.io.DataOutputStream;
import java.io.IOException;

public class png_chunk_trns
implements PNGConstants {
    protected byte[] alphaValues;
    protected int lastTransparentIndex = -1;
    protected PNGChunkUtil pngUtil;
    private static final int NO_TRANSPARENT_PIXELS = -1;

    public png_chunk_trns(AdaptiveRasterImage ji, PNGChunkUtil pngUtil, PNGEncoder encoder) throws JimiException {
        this.pngUtil = pngUtil;
        if (!(ji.getColorModel() instanceof IndexColorModel)) {
            return;
        }
        IndexColorModel cm = (IndexColorModel)ji.getColorModel();
        this.alphaValues = new byte[cm.getMapSize()];
        cm.getAlphas(this.alphaValues);
        for (int index = 0; index < this.alphaValues.length; ++index) {
            if (this.alphaValues[index] == 255) continue;
            this.lastTransparentIndex = index;
        }
    }

    public void write(DataOutputStream out) throws IOException {
        if (this.lastTransparentIndex == -1) {
            return;
        }
        out.writeInt(this.lastTransparentIndex + 1);
        out.write(PNGConstants.png_tRNS);
        this.pngUtil.resetCRC();
        this.pngUtil.updateCRC(PNGConstants.png_tRNS);
        for (int i = 0; i <= this.lastTransparentIndex; ++i) {
            out.write(this.alphaValues[i]);
            this.pngUtil.updateCRC(this.alphaValues[i]);
        }
        out.writeInt(this.pngUtil.getCRC());
    }
}

