/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.psd;

import com.sun.jimi.core.InvalidOptionException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.OptionsObject;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.encoder.psd.EncodeImageIfc;
import com.sun.jimi.core.encoder.psd.PSDColorMode;
import com.sun.jimi.core.encoder.psd.PSDFileHeader;
import com.sun.jimi.util.ArrayEnumeration;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class PSDEncoder
extends JimiEncoderBase
implements OptionsObject {
    private OutputStream out_;
    private DataOutputStream dOut_;
    private int state_;
    static final int NO_COMPRESSION = 0;
    static final int RLE_COMPRESSION = 1;
    static final int DEFAULT_COMPRESSION = 0;
    int compression_ = 0;
    static final String COMPRESSION_OPTION_NAME = "compression";
    static final String NO_COMPRESSION_OPTION = "none";
    static final String RLE_COMPRESSION_OPTION = "rle";
    static final String[] POSSIBLE_COMPRESSION_OPTIONS = new String[]{"none", "rle"};
    static final String[] PROPERTY_NAMES = new String[]{"compression"};

    protected void initSpecificEncoder(OutputStream out, AdaptiveRasterImage ji) throws JimiException {
        this.out_ = out;
        this.dOut_ = new DataOutputStream(out);
        this.state_ = 0;
    }

    public OptionsObject getOptionsObject() {
        return this;
    }

    public boolean driveEncoder() throws JimiException {
        AdaptiveRasterImage ji = this.getJimiImage();
        try {
            this.encodePSD(ji, this.dOut_);
            this.state_ |= 2;
            this.dOut_.flush();
            this.dOut_.close();
        }
        catch (IOException e) {
            throw new JimiException(e.getMessage());
        }
        return false;
    }

    public void freeEncoder() throws JimiException {
        this.out_ = null;
        this.dOut_ = null;
        super.freeEncoder();
    }

    public int getState() {
        return this.state_;
    }

    public void encodePSD(AdaptiveRasterImage ji, DataOutputStream out) throws JimiException, IOException {
        PSDFileHeader psdFH = new PSDFileHeader(this, ji, out);
        psdFH.write();
        PSDColorMode psdCM = new PSDColorMode(ji, out);
        psdCM.write();
        out.writeInt(0);
        out.writeInt(0);
        EncodeImageIfc encImage = psdFH.createEncodeImage();
        encImage.encodeImage(ji, out, this.compression_);
    }

    public Enumeration getPropertyNames() {
        return new ArrayEnumeration(PROPERTY_NAMES);
    }

    public Object getProperty(String key) {
        if (key.equalsIgnoreCase(COMPRESSION_OPTION_NAME)) {
            if (this.compression_ == 0) {
                return NO_COMPRESSION_OPTION;
            }
            return RLE_COMPRESSION_OPTION;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String key, Object val) throws InvalidOptionException {
        if (!key.equalsIgnoreCase(COMPRESSION_OPTION_NAME)) throw new InvalidOptionException("No such option");
        String value = val.toString();
        if (value.equalsIgnoreCase(NO_COMPRESSION_OPTION)) {
            this.compression_ = 0;
            return;
        } else {
            if (!value.equalsIgnoreCase(RLE_COMPRESSION_OPTION)) throw new InvalidOptionException("Not a valid value");
            this.compression_ = 1;
        }
    }

    public Object getPossibleValuesForProperty(String name) throws InvalidOptionException {
        if (name.equalsIgnoreCase(COMPRESSION_OPTION_NAME)) {
            return POSSIBLE_COMPRESSION_OPTIONS;
        }
        throw new InvalidOptionException("No such option");
    }

    public String getPropertyDescription(String name) throws InvalidOptionException {
        if (name.equalsIgnoreCase(COMPRESSION_OPTION_NAME)) {
            return "RLE compression tends to be smaller than not using compression";
        }
        throw new InvalidOptionException("No such option");
    }

    public void clearProperties() {
        this.compression_ = 0;
    }
}

