/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.psd;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.encoder.psd.EncodeImageIfc;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.Packbits;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataOutputStream;
import java.io.IOException;

class PSDFileHeader
implements EncodeImageIfc {
    static final int PSD_SIGNATURE = 943870035;
    static final short BITMAP = 0;
    static final short GRAYSCALE = 1;
    static final short INDEXED = 2;
    static final short RGB = 3;
    AdaptiveRasterImage ji_;
    DataOutputStream out_;
    short channels_;
    int rows_;
    int cols_;
    short depth_;
    short colorMode_;
    JimiEncoderBase encoder_;
    short[] SLLTable_;
    int sllOffset_;

    PSDFileHeader(JimiEncoderBase encoder, AdaptiveRasterImage ji, DataOutputStream out) throws JimiException {
        this.ji_ = ji;
        this.out_ = out;
        this.encoder_ = encoder;
        this.colorMode_ = (short)-1;
        ColorModel cm = this.ji_.getColorModel();
        this.cols_ = this.ji_.getWidth();
        this.rows_ = this.ji_.getHeight();
        if (cm instanceof IndexColorModel) {
            this.channels_ = 1;
            this.colorMode_ = (short)2;
            this.depth_ = (short)8;
        } else if (cm instanceof DirectColorModel) {
            DirectColorModel dCM = (DirectColorModel)cm;
            int rMask = dCM.getRedMask();
            int gMask = dCM.getGreenMask();
            int bMask = dCM.getBlueMask();
            int pixelSize = dCM.getPixelSize();
            if (rMask == (1 << pixelSize) - 1 && rMask == gMask && gMask == bMask) {
                this.channels_ = 1;
                if (pixelSize == 1) {
                    this.depth_ = 1;
                    this.colorMode_ = 0;
                } else {
                    this.depth_ = (short)8;
                    this.colorMode_ = 1;
                }
            }
        }
        if (this.colorMode_ == -1) {
            this.channels_ = (short)3;
            this.colorMode_ = (short)3;
            this.depth_ = (short)8;
            this.ji_.setRGBDefault(true);
        }
    }

    void write() throws IOException {
        this.out_.writeInt(943870035);
        this.out_.writeShort(1);
        int i = 6;
        while (--i >= 0) {
            this.out_.writeByte(0);
        }
        this.out_.writeShort(this.channels_);
        this.out_.writeInt(this.rows_);
        this.out_.writeInt(this.cols_);
        this.out_.writeShort(this.depth_);
        this.out_.writeShort(this.colorMode_);
    }

    EncodeImageIfc createEncodeImage() {
        return this;
    }

    public void encodeImage(AdaptiveRasterImage ji, DataOutputStream out, int compression) throws JimiException {
        try {
            out.writeShort(compression);
            switch (this.colorMode_) {
                case 0: {
                    if (compression == 0) {
                        this.outputGrayChannel(3, ji, out, 0);
                        break;
                    }
                    this.outputRLE(ji, out);
                    break;
                }
                case 1: {
                    if (compression == 0) {
                        this.outputGrayChannel(3, ji, out, 0);
                        break;
                    }
                    this.outputRLE(ji, out);
                    break;
                }
                case 2: {
                    if (compression == 0) {
                        this.outputRawChannel(3, ji, out);
                        break;
                    }
                    this.outputRLE(ji, out);
                    break;
                }
                case 3: {
                    if (compression == 0) {
                        this.outputRawRGB(ji, out);
                        break;
                    }
                    this.outputRLERGB(ji, out);
                }
            }
        }
        catch (IOException e) {
            throw new JimiException(e.getMessage());
        }
    }

    void outputRawRGB(AdaptiveRasterImage ji, DataOutputStream out) throws JimiException, IOException {
        this.outputRawChannel(16, ji, out);
        this.outputRawChannel(8, ji, out);
        this.outputRawChannel(0, ji, out);
    }

    void outputRLERGB(AdaptiveRasterImage ji, DataOutputStream out) throws JimiException, IOException {
        byte[] rowBuf = new byte[this.cols_];
        short[] SLLTable = new short[this.rows_ * this.channels_];
        int offset = 0;
        this.getRLELens(16, ji, SLLTable, offset);
        this.getRLELens(8, ji, SLLTable, offset += this.rows_);
        this.getRLELens(0, ji, SLLTable, offset += this.rows_);
        for (int i = 0; i < SLLTable.length; ++i) {
            out.write((SLLTable[i] & 0xFF00) >> 8);
            out.write(SLLTable[i] & 0xFF);
        }
        this.outputRLEChannel(16, ji, out);
        this.outputRLEChannel(8, ji, out);
        this.outputRLEChannel(0, ji, out);
    }

    void outputRLE(AdaptiveRasterImage ji, DataOutputStream out) throws JimiException, IOException {
        short[] SLLTable = new short[this.rows_ * this.channels_];
        if (this.colorMode_ == 2) {
            this.getRLELens(0, ji, SLLTable, 0);
        } else {
            this.SLLTable_ = SLLTable;
            this.sllOffset_ = 0;
            this.outputGrayChannel(0, ji, out, 1);
            this.SLLTable_ = null;
        }
        for (int i = 0; i < SLLTable.length; ++i) {
            out.write((SLLTable[i] & 0xFF00) >> 8);
            out.write(SLLTable[i] & 0xFF);
        }
        if (this.colorMode_ == 2) {
            this.outputRLEChannel(0, ji, out);
        } else {
            this.outputGrayChannel(0, ji, out, 1);
        }
    }

    void outputGrayChannel(int channel, AdaptiveRasterImage ji, DataOutputStream out, int compression) throws JimiException, IOException {
        byte[] rowBuf = new byte[this.cols_];
        byte[] rowBufC = null;
        byte[] packedBuf = null;
        if (compression != 0) {
            rowBufC = new byte[this.cols_ + this.cols_ / 128 + 1];
        }
        int pixelSize = ji.getColorModel().getPixelSize();
        boolean whiteIsZero = false;
        ColorModel cm = ji.getColorModel();
        for (int row = 0; row < this.rows_; ++row) {
            int len;
            int i;
            this.encoder_.setProgress(row * 100 / this.rows_);
            ji.getChannel(channel, row, rowBuf, 0);
            if (pixelSize == 1) {
                if (packedBuf == null) {
                    packedBuf = new byte[rowBuf.length / 8 + (rowBuf.length % 8 != 0 ? 1 : 0)];
                }
                JimiUtil.packPixels(1, rowBuf, packedBuf);
                if (!whiteIsZero) {
                    i = packedBuf.length;
                    while (--i >= 0) {
                        packedBuf[i] = ~packedBuf[i];
                    }
                }
                if (compression == 0) {
                    out.write(packedBuf);
                    continue;
                }
                len = Packbits.packbits(packedBuf, rowBufC);
                if (this.SLLTable_ != null) {
                    this.SLLTable_[this.sllOffset_++] = (short)len;
                    continue;
                }
                out.write(rowBufC, 0, len);
                continue;
            }
            if (pixelSize < 8) {
                JimiUtil.pixelDepthChange(pixelSize, rowBuf, 8);
            }
            if (whiteIsZero) {
                i = rowBuf.length;
                while (--i >= 0) {
                    rowBuf[i] = ~rowBuf[i];
                }
            }
            if (compression == 0) {
                out.write(rowBuf);
                continue;
            }
            len = Packbits.packbits(rowBuf, rowBufC);
            if (this.SLLTable_ != null) {
                this.SLLTable_[this.sllOffset_++] = (short)len;
                continue;
            }
            out.write(rowBufC, 0, len);
        }
    }

    void outputRawChannel(int channel, AdaptiveRasterImage ji, DataOutputStream out) throws JimiException, IOException {
        byte[] rowBuf = new byte[this.cols_];
        for (int row = 0; row < this.rows_; ++row) {
            ji.getChannel(channel, row, rowBuf, 0);
            out.write(rowBuf);
            this.encoder_.setProgress(row * 100 / this.rows_);
        }
    }

    void getRLELens(int channel, AdaptiveRasterImage ji, short[] SLLtable, int offset) throws JimiException, IOException {
        byte[] rowBuf = new byte[this.cols_];
        byte[] rowBufC = new byte[this.cols_ + this.cols_ / 128 + 1];
        for (int row = 0; row < this.rows_; ++row) {
            ji.getChannel(channel, row, rowBuf, 0);
            SLLtable[offset] = (short)Packbits.packbits(rowBuf, rowBufC);
            ++offset;
            this.encoder_.setProgress(row * 100 / this.rows_);
        }
    }

    void outputRLEChannel(int channel, AdaptiveRasterImage ji, DataOutputStream out) throws JimiException, IOException {
        byte[] rowBuf = new byte[this.cols_];
        byte[] rowBufC = new byte[this.cols_ + this.cols_ / 128 + 1];
        for (int row = 0; row < this.rows_; ++row) {
            ji.getChannel(channel, row, rowBuf, 0);
            int len = Packbits.packbits(rowBuf, rowBufC);
            out.write(rowBufC, 0, len);
            this.encoder_.setProgress(row * 100 / this.rows_);
        }
    }
}

