/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.sunraster;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.sunraster.RLEOutputStream;
import com.sun.jimi.core.encoder.sunraster.SpecificEncoder;
import com.sun.jimi.core.encoder.sunraster.SunRasterHeader;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;

public class PaletteSunRasterEncoder
extends SpecificEncoder {
    protected boolean useRLE_ = false;

    public void doImageEncode() throws JimiException {
        AdaptiveRasterImage ji = this.getJimiImage();
        try {
            this.writeImage();
        }
        catch (IOException e) {
            throw new JimiException(e.toString());
        }
    }

    public void setUseRLE(boolean flag) {
        this.useRLE_ = flag;
    }

    protected void writeImage() throws IOException, JimiException {
        AdaptiveRasterImage ji = this.getJimiImage();
        SunRasterHeader header = this.getHeader();
        header.setDepth(8);
        if (this.useRLE_) {
            header.setType(2);
        } else {
            header.setType(1);
        }
        header.setPalette((IndexColorModel)ji.getColorModel());
        this.writeHeader();
        OutputStream out = this.getOutputStream();
        if (this.useRLE_) {
            out = new RLEOutputStream(out);
        }
        int height = ji.getHeight();
        int width = ji.getWidth();
        int buffer_size = width;
        if (buffer_size % 2 != 0) {
            ++buffer_size;
        }
        byte[] buf = new byte[buffer_size];
        for (int i = 0; i < height; ++i) {
            ji.getChannel(0, i, buf, 0);
            out.write(buf);
        }
        out.flush();
    }
}

