/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.sunraster;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.sunraster.SpecificEncoder;
import com.sun.jimi.core.encoder.sunraster.SunRasterHeader;
import java.io.IOException;
import java.io.OutputStream;

public class RGBSunRasterEncoder
extends SpecificEncoder {
    public void doImageEncode() throws JimiException {
        AdaptiveRasterImage ji = this.getJimiImage();
        ji.setRGBDefault(true);
        try {
            this.writeImage();
        }
        catch (IOException e) {
            throw new JimiException(e.toString());
        }
    }

    protected void writeImage() throws IOException, JimiException {
        SunRasterHeader header = this.getHeader();
        header.setDepth(24);
        header.setType(3);
        this.writeHeader();
        OutputStream out = this.getOutputStream();
        AdaptiveRasterImage ji = this.getJimiImage();
        int height = ji.getHeight();
        int width = ji.getWidth();
        int buffer_size = width * 3;
        if (buffer_size % 2 != 0) {
            ++buffer_size;
        }
        byte[] buf = new byte[buffer_size];
        for (int i = 0; i < height; ++i) {
            ji.getChannelRGB(i, buf, 0);
            out.write(buf);
        }
    }
}

