/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.sunraster;

import java.io.IOException;
import java.io.OutputStream;

public class RLEOutputStream
extends OutputStream {
    protected static final byte FLAG_VALUE = -128;
    protected OutputStream out_;
    protected byte runValue_;
    protected int runCount_;

    public RLEOutputStream(OutputStream out) {
        this.out_ = out;
    }

    protected synchronized void compressBytes(byte[] data, int offset, int len) throws IOException {
        int max_length = len;
        int run_count = this.runCount_;
        byte run_value = this.runValue_;
        OutputStream out = this.out_;
        for (int idx = offset; idx < max_length; ++idx) {
            byte value = data[idx];
            if (run_count == 0) {
                run_value = value;
                run_count = 1;
                continue;
            }
            if (value == run_value && run_count < 255) {
                ++run_count;
                continue;
            }
            this.writeRun(run_count, run_value);
            run_value = value;
            run_count = 1;
        }
        this.runCount_ = run_count;
        this.runValue_ = run_value;
    }

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        this.compressBytes(data, offset, length);
    }

    public void write(int value) throws IOException {
        byte[] byte_array = new byte[]{(byte)value};
        this.write(byte_array);
    }

    public void flush() throws IOException {
        this.writeRun();
        this.runCount_ = 0;
        this.runValue_ = (byte)-1;
    }

    protected void writeRun(int run_count, byte run_value) throws IOException {
        if (run_count > 2) {
            this.out_.write(-128);
            this.out_.write((byte)run_count - 1);
            this.out_.write(run_value);
        } else {
            while (run_count-- > 0) {
                this.writeLiteral(run_value);
            }
        }
    }

    protected void writeRun() throws IOException {
        this.writeRun(this.runCount_, this.runValue_);
    }

    protected void writeLiteral(byte value) throws IOException {
        this.out_.write(value);
        if (value == -128) {
            this.out_.write(0);
        }
    }
}

