/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.sunraster;

import com.sun.jimi.core.InvalidOptionException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.OptionsObject;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.encoder.sunraster.PaletteSunRasterEncoder;
import com.sun.jimi.core.encoder.sunraster.RGBSunRasterEncoder;
import com.sun.jimi.core.encoder.sunraster.SpecificEncoder;
import com.sun.jimi.core.encoder.sunraster.SunRasterHeader;
import com.sun.jimi.core.options.SunRasterOptions;
import com.sun.jimi.util.ArrayEnumeration;
import com.sun.jimi.util.PropertyOwner;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.OutputStream;
import java.util.Enumeration;

public class SunRasterEncoder
extends JimiEncoderBase
implements OptionsObject {
    protected int state_;
    protected OutputStream output_;
    static final boolean DEFAULT_COMPRESSION = true;
    protected boolean useRLE_ = true;
    static final String OPTION_COMPRESSION = "compression";
    static final Boolean[] POSSIBLE_COMPRESSION_VALUES = PropertyOwner.BOOLEAN_ARRAY;
    static final String[] OPTION_NAMES = new String[]{"compression"};

    public void initSpecificEncoder(OutputStream out, AdaptiveRasterImage ji) {
        this.output_ = out;
        if (ji.getOptions() instanceof SunRasterOptions) {
            this.setUseRLE(((SunRasterOptions)ji.getOptions()).isUsingRLE());
        }
    }

    public boolean driveEncoder() throws JimiException {
        try {
            SpecificEncoder encoder = this.createEncoder();
            encoder.doImageEncode();
        }
        catch (JimiException e) {
            this.state_ = 1;
            throw e;
        }
        this.state_ = 2;
        return false;
    }

    public int getState() {
        return this.state_;
    }

    protected SpecificEncoder createEncoder() throws JimiException {
        SpecificEncoder encoder;
        AdaptiveRasterImage ji = this.getJimiImage();
        SunRasterHeader header = new SunRasterHeader(ji);
        ColorModel cm = ji.getColorModel();
        if (cm instanceof IndexColorModel && cm.getPixelSize() == 8) {
            encoder = new PaletteSunRasterEncoder();
            ((PaletteSunRasterEncoder)encoder).setUseRLE(this.useRLE_);
        } else {
            encoder = new RGBSunRasterEncoder();
        }
        encoder.initEncoder(header, this.output_, ji);
        return encoder;
    }

    public OptionsObject getOptionsObject() {
        return this;
    }

    void setUseRLE(boolean useRLE) {
        this.useRLE_ = useRLE;
    }

    public Enumeration getPropertyNames() {
        return new ArrayEnumeration(OPTION_NAMES);
    }

    public Object getPossibleValuesForProperty(String name) {
        if (name.equalsIgnoreCase(OPTION_COMPRESSION)) {
            return POSSIBLE_COMPRESSION_VALUES;
        }
        return null;
    }

    public void setProperty(String name, Object value) throws InvalidOptionException {
        if (name.equalsIgnoreCase(OPTION_COMPRESSION)) {
            try {
                this.setUseRLE((Boolean)value);
            }
            catch (ClassCastException cce) {
                throw new InvalidOptionException("Must specify a java.lang.Boolean value");
            }
        }
        throw new InvalidOptionException("No such option");
    }

    public void clearProperties() {
        this.setUseRLE(true);
    }

    public String getPropertyDescription(String name) throws InvalidOptionException {
        if (name.equalsIgnoreCase(OPTION_COMPRESSION)) {
            return "RLE compression tends to be smaller than not using compression";
        }
        throw new InvalidOptionException("No such option");
    }

    public Object getProperty(String name) {
        return null;
    }
}

