/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.sunraster;

import com.sun.jimi.core.compat.AdaptiveRasterImage;
import java.awt.image.IndexColorModel;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SunRasterHeader {
    protected static final int MAGIC_NUMBER = 1504078485;
    public static final int TYPE_OLD = 0;
    public static final int TYPE_STANDARD = 1;
    public static final int TYPE_BYTE_ENCODED = 2;
    public static final int TYPE_RGB = 3;
    public static final int TYPE_TIFF = 4;
    public static final int TYPE_IFF = 5;
    public static final int TYPE_EXPERIMENTAL = 65535;
    public static final int NO_COLOR_MAP = 0;
    public static final int RGB_COLOR_MAP = 1;
    public static final int RAW_COLOR_MAP = 2;
    protected static final int NO_COLORMAP = 0;
    protected static final int RGB_COLORMAP = 1;
    protected static final int RAW_COLORMAP = 2;
    protected AdaptiveRasterImage jimiImage_;
    protected int width_;
    protected int height_;
    protected int depth_;
    protected int type_;
    protected int colorMapType_;
    protected int colorMapLength_;
    protected IndexColorModel palette_;
    protected int scanLineSize_;

    public SunRasterHeader() {
        this.type_ = 1;
        this.colorMapType_ = 0;
    }

    public SunRasterHeader(AdaptiveRasterImage image) {
        this.width_ = image.getWidth();
        this.height_ = image.getHeight();
        this.type_ = 1;
        this.colorMapType_ = 0;
    }

    public void setDepth(int depth) {
        this.depth_ = depth;
    }

    public int getDepth() {
        return this.depth_;
    }

    public void setType(int type) {
        this.type_ = type;
    }

    public int getType() {
        return this.type_;
    }

    public void setPalette(IndexColorModel palette) {
        this.palette_ = palette;
    }

    public IndexColorModel getPalette() {
        return this.palette_;
    }

    public void writeTo(OutputStream output) throws IOException {
        DataOutputStream data_out = new DataOutputStream(output);
        data_out.writeInt(1504078485);
        data_out.writeInt(this.width_);
        data_out.writeInt(this.height_);
        data_out.writeInt(this.depth_);
        data_out.writeInt(0);
        data_out.writeInt(this.type_);
        this.writePaletteInfoTo(data_out);
        data_out.flush();
    }

    protected void writePaletteInfoTo(DataOutputStream out) throws IOException {
        if (this.palette_ == null) {
            out.writeInt(0);
            out.writeInt(0);
        } else {
            byte[] palette_channel = new byte[this.palette_.getMapSize()];
            out.writeInt(1);
            out.writeInt(palette_channel.length * 3);
            this.palette_.getReds(palette_channel);
            out.write(palette_channel);
            this.palette_.getGreens(palette_channel);
            out.write(palette_channel);
            this.palette_.getBlues(palette_channel);
            out.write(palette_channel);
        }
    }
}

