/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.tga;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.tga.TGAEncoderIfc;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.io.IOException;

public class TGA24Encoder
implements TGAEncoderIfc {
    public void encodeTGA(AdaptiveRasterImage ji, LEDataOutputStream out) throws JimiException {
        try {
            int w = ji.getWidth();
            int h = ji.getHeight();
            out.write(0);
            out.write(0);
            out.write(2);
            out.write(0);
            out.write(0);
            out.write(0);
            out.write(0);
            out.write(0);
            out.writeShort(0);
            out.writeShort(0);
            out.writeShort(w);
            out.writeShort(h);
            out.write(24);
            out.write(0);
            int[] buf = new int[w];
            byte[] outBuf = new byte[w * 3];
            ji.setRGBDefault(true);
            for (int i = 0; i < h; ++i) {
                int y = h - i - 1;
                ji.getChannel(y, buf, 0);
                int idx = 3 * w;
                int j = w;
                while (--j >= 0) {
                    outBuf[--idx] = (byte)((buf[j] & 0xFF0000) >> 16);
                    outBuf[--idx] = (byte)((buf[j] & 0xFF00) >> 8);
                    outBuf[--idx] = (byte)((buf[j] & 0xFF) >> 0);
                }
                out.write(outBuf);
            }
        }
        catch (IOException e) {
            throw new JimiException("TGA24Encoder encodeTGA() IOException encountered");
        }
    }
}

