/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.tga;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.tga.TGAEncoderIfc;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.awt.image.IndexColorModel;
import java.io.IOException;

public class TGA8Encoder
implements TGAEncoderIfc {
    public void encodeTGA(AdaptiveRasterImage ji, LEDataOutputStream out) throws JimiException {
        IndexColorModel model;
        try {
            model = (IndexColorModel)ji.getColorModel();
        }
        catch (ClassCastException cce) {
            throw new JimiException("TGA8 requires an IndexColorModel.");
        }
        int palette_size = model.getMapSize();
        try {
            int i;
            int w = ji.getWidth();
            int h = ji.getHeight();
            out.writeByte(0);
            out.writeByte(1);
            out.writeByte(1);
            out.writeShort(0);
            out.writeShort(palette_size);
            out.writeByte(24);
            out.writeShort(0);
            out.writeShort(0);
            out.writeShort(w);
            out.writeShort(h);
            out.write(8);
            out.write(0);
            byte[] reds = new byte[palette_size];
            byte[] greens = new byte[palette_size];
            byte[] blues = new byte[palette_size];
            model.getReds(reds);
            model.getGreens(greens);
            model.getBlues(blues);
            for (i = 0; i < palette_size; ++i) {
                out.writeByte(blues[i]);
                out.writeByte(greens[i]);
                out.writeByte(reds[i]);
            }
            byte[] buf = new byte[w];
            for (i = 0; i < h; ++i) {
                int y = h - i - 1;
                ji.getChannel(0, y, buf, 0);
                out.write(buf);
            }
        }
        catch (IOException e) {
            throw new JimiException("TGA8Encoder encodeTGA() IOException encountered");
        }
    }
}

