/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.tga;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.encoder.tga.TGA24Encoder;
import com.sun.jimi.core.encoder.tga.TGA8Encoder;
import com.sun.jimi.core.encoder.tga.TGAEncoderIfc;
import com.sun.jimi.core.util.LEDataOutputStream;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;

public class TGAEncoder
extends JimiEncoderBase
implements TGAEncoderIfc {
    private OutputStream out;
    private LEDataOutputStream bOut;
    private int state;

    protected void initSpecificEncoder(OutputStream out, AdaptiveRasterImage ji) throws JimiException {
        this.out = out;
        this.bOut = new LEDataOutputStream(out);
        this.state = 0;
    }

    public boolean driveEncoder() throws JimiException {
        AdaptiveRasterImage ji = this.getJimiImage();
        this.encodeTGA(ji, this.bOut);
        this.state |= 2;
        try {
            this.bOut.flush();
            this.bOut.close();
        }
        catch (IOException e) {
            throw new JimiException("TGAEncoder driveEncoder() IO Exception encountered");
        }
        return false;
    }

    public void freeEncoder() throws JimiException {
        AdaptiveRasterImage ji = this.getJimiImage();
        this.out = null;
        this.bOut = null;
        super.freeEncoder();
    }

    public int getState() {
        return this.state;
    }

    public void encodeTGA(AdaptiveRasterImage ji, LEDataOutputStream out) throws JimiException {
        this.createEncoderForImage(ji).encodeTGA(ji, out);
    }

    protected TGAEncoderIfc createEncoderForImage(AdaptiveRasterImage image) {
        ColorModel cm = image.getColorModel();
        if (cm instanceof IndexColorModel && cm.getPixelSize() == 8) {
            return new TGA8Encoder();
        }
        return new TGA24Encoder();
    }
}

