/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.xbm;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.util.JimiImageColorReducer;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class XBMEncoder
extends JimiEncoderBase {
    protected PrintStream output;
    protected AdaptiveRasterImage jimiImage;
    protected int state;

    public void initSpecificEncoder(OutputStream out, AdaptiveRasterImage image) {
        this.output = new PrintStream(out);
    }

    public boolean driveEncoder() throws JimiException {
        try {
            this.jimiImage = this.getJimiImage();
            this.doImageEncode();
        }
        catch (Exception e) {
            this.state = 1;
            throw new JimiException(e.getMessage());
        }
        this.state = 2;
        return false;
    }

    public int getState() {
        return this.state;
    }

    protected void doImageEncode() throws JimiException, IOException {
        this.jimiImage = this.getJimiImage();
        this.writeHeader();
        this.writeImageData();
        this.writeTrailer();
    }

    protected void writeHeader() {
        this.output.println("#define jimi_xbitmap_width " + this.jimiImage.getWidth());
        this.output.println("#define jimi_xbitmap_height " + this.jimiImage.getHeight());
        this.output.println("static char jimi_xbitmap_bits = {");
    }

    protected void writeImageData() throws JimiException {
        int intensityCol1;
        JimiImageColorReducer reducer = new JimiImageColorReducer(2);
        this.jimiImage = new AdaptiveRasterImage(reducer.colorReduceFS(this.jimiImage.getBackend()));
        IndexColorModel indexCM = (IndexColorModel)this.jimiImage.getColorModel();
        int intensityCol0 = this.intensity(indexCM.getRGB(0));
        int transparentColor = intensityCol0 < (intensityCol1 = this.intensity(indexCM.getRGB(1))) ? intensityCol0 : intensityCol1;
        int width = this.jimiImage.getWidth();
        int height = this.jimiImage.getHeight();
        int packedWidth = width % 8 == 0 ? width / 8 : width / 8 + 1;
        int[] rowBuffer = new int[packedWidth * 8];
        for (int row = 0; row < height; ++row) {
            int bufOffset = 0;
            this.jimiImage.getChannel(row, rowBuffer, 0);
            for (int x = 0; x < packedWidth; ++x) {
                int value = 0;
                for (int bitOffset = 0; bitOffset < 8; ++bitOffset) {
                    if (rowBuffer[bufOffset++] == transparentColor) continue;
                    value = (byte)(value | 1 << bitOffset);
                }
                this.output.print("0x" + Integer.toHexString(value & 0xFF));
                if (row == height - 1 && x >= packedWidth - 1) continue;
                this.output.print(",");
            }
            this.output.println();
        }
    }

    protected int intensity(int rgb) {
        return (rgb & 0xFF) + (rgb >> 8 & 0xFF) + (rgb >> 16 & 0xFF);
    }

    protected void writeTrailer() {
        this.output.println("};");
    }
}

