/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.xpm;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class XPMEncoder
extends JimiEncoderBase {
    protected static final String MAGIC = "/* XPM */\n";
    protected static final String HEADER_STRING = "static char* image[]={\n";
    protected static char[] paletteStringCharacters;
    protected PrintStream output;
    protected AdaptiveRasterImage jimiImage;
    protected int state;
    protected int paletteSize;
    protected String[] paletteStrings;
    protected int entrySize;

    public XPMEncoder() {
        if (paletteStringCharacters == null) {
            this.generatePaletteStringCharacters();
        }
    }

    public void initSpecificEncoder(OutputStream out, AdaptiveRasterImage image) {
        this.output = new PrintStream(out);
    }

    public boolean driveEncoder() throws JimiException {
        try {
            this.jimiImage = this.getJimiImage();
            this.doImageEncode();
        }
        catch (Exception e) {
            this.state = 1;
            e.printStackTrace();
            throw new JimiException(e.toString());
        }
        this.state = 2;
        return false;
    }

    public int getState() {
        return this.state;
    }

    protected void doImageEncode() throws JimiException, IOException {
        if (!(this.jimiImage.getColorModel() instanceof IndexColorModel)) {
            throw new JimiException("XPM only encodes palette-based images.");
        }
        IndexColorModel cModel = (IndexColorModel)this.jimiImage.getColorModel();
        this.createPaletteStrings(cModel);
        this.writeHeader();
        this.writePalette(cModel);
        this.writeImageData();
        this.writeTrailer();
    }

    protected void createPaletteStrings(IndexColorModel cm) {
        int size = cm.getMapSize();
        this.entrySize = 0;
        int remainingEntries = size;
        do {
            ++this.entrySize;
        } while ((remainingEntries /= paletteStringCharacters.length) != 0);
        this.paletteStrings = new String[size];
        for (int index = 0; index < size; ++index) {
            int entryNumber = index;
            String paletteString = "";
            for (int i = 0; i < this.entrySize; ++i) {
                paletteString = String.valueOf(paletteStringCharacters[entryNumber % paletteStringCharacters.length]) + paletteString;
                entryNumber /= paletteStringCharacters.length;
            }
            this.paletteStrings[index] = paletteString;
        }
    }

    protected void writeHeader() throws IOException {
        this.output.print(MAGIC);
        this.output.print(HEADER_STRING);
        int width = this.jimiImage.getWidth();
        int height = this.jimiImage.getHeight();
        this.output.println("\"" + width + " " + height + " " + this.paletteStrings.length + " " + this.entrySize + "\",");
    }

    protected void writePalette(IndexColorModel cm) throws IOException {
        for (int index = 0; index < this.paletteStrings.length; ++index) {
            this.output.println("\"" + this.paletteStrings[index] + " c #" + this.toPaddedHexString(cm.getRGB(index) & 0xFFFFFF) + "\",");
        }
    }

    protected void writeImageData() throws IOException, JimiException {
        int[] rowBuffer = new int[this.jimiImage.getWidth()];
        int height = this.jimiImage.getHeight();
        for (int row = 0; row < height; ++row) {
            this.jimiImage.getChannel(row, rowBuffer, 0);
            this.output.print("\"");
            for (int x = 0; x < rowBuffer.length; ++x) {
                this.output.print(this.paletteStrings[rowBuffer[x]]);
            }
            if (row >= height - 1) continue;
            this.output.println("\",");
        }
    }

    protected void writeTrailer() throws IOException {
        this.output.println("\"};");
    }

    protected String toPaddedHexString(int value) {
        String valueString = Integer.toHexString(value);
        while (valueString.length() < 6) {
            valueString = "0" + valueString;
        }
        return valueString;
    }

    protected void generatePaletteStringCharacters() {
        int value;
        int numberOfCharacters = 62;
        paletteStringCharacters = new char[numberOfCharacters];
        int index = 0;
        for (value = 48; value <= 57; value = (int)((char)(value + 1))) {
            XPMEncoder.paletteStringCharacters[index++] = value;
        }
        for (value = 97; value <= 122; value = (int)((char)(value + 1))) {
            XPMEncoder.paletteStringCharacters[index++] = value;
        }
        for (value = 65; value <= 90; value = (int)((char)(value + 1))) {
            XPMEncoder.paletteStringCharacters[index++] = value;
        }
    }
}

