/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.ReplicatingScaleFilter;
import java.awt.image.ColorModel;

public class AspectReplicateScaleFilter
extends ReplicatingScaleFilter {
    protected int fixedDimension;
    protected int maxWidth;
    protected int maxHeight;
    protected boolean noScaling;

    public AspectReplicateScaleFilter(int width, int height) {
        super(width, height);
        this.maxWidth = width;
        this.maxHeight = height;
    }

    public void setDimensions(int imageWidth, int imageHeight) {
        this.srcWidth = imageWidth;
        this.srcHeight = imageHeight;
        if (imageWidth <= this.maxWidth && imageHeight <= this.maxHeight) {
            this.destWidth = imageWidth;
            this.destHeight = imageHeight;
            this.noScaling = true;
            this.consumer.setDimensions(imageWidth, imageHeight);
        } else {
            int thumbnailWidth;
            int thumbnailHeight;
            double xProportion = (double)imageWidth / (double)this.maxWidth;
            double yProportion = (double)imageHeight / (double)this.maxHeight;
            if (xProportion < yProportion) {
                thumbnailHeight = this.maxHeight;
                thumbnailWidth = (int)((double)imageWidth / yProportion);
            } else {
                thumbnailWidth = this.maxWidth;
                thumbnailHeight = (int)((double)imageHeight / xProportion);
            }
            this.destWidth = thumbnailWidth;
            this.destHeight = thumbnailHeight;
            this.consumer.setDimensions(this.destWidth, this.destHeight);
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        if (this.noScaling) {
            this.consumer.setPixels(x, y, w, h, model, pixels, off, scansize);
        } else {
            super.setPixels(x, y, w, h, model, pixels, off, scansize);
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (this.noScaling) {
            this.consumer.setPixels(x, y, w, h, model, pixels, off, scansize);
        } else {
            super.setPixels(x, y, w, h, model, pixels, off, scansize);
        }
    }
}

